<?php
/**
 * Yii Google Maps markers
 *
 * @author Marc Oliveras Galvez <oligalma@gmail.com> 
 * @link http://www.ho96.com
 * @copyright 2015 Hosting 96
 * @license New BSD License
 */
    Yii::app()->clientScript->registerCssFile($this->module->assetsUrl . '/css/markers.css');
	Yii::app()->clientScript->registerCssFile($this->module->assetsUrl . '/css/form.css');
    Yii::app()->clientScript->registerScriptFile($this->module->assetsUrl . '/js/tinymce/tinymce.min.js', CClientScript::POS_END);
    Yii::app()->clientScript->registerScriptFile('https://maps.googleapis.com/maps/api/js?sensor=false', CClientScript::POS_END);
    Yii::app()->clientScript->registerScript('markerjs','
        tinymce.init({'
            . (file_exists(dirname(__FILE__) . '/../../assets/js/tinymce/langs/' . Yii::app()->getLanguage() . '.js') ? ('language: "' . Yii::app()->getLanguage() . '",') : '') .
            'selector: "#Marker_text",
            theme: "modern",
            plugins: [
                "advlist autolink lists link image charmap print preview hr anchor pagebreak",
                "searchreplace wordcount visualblocks visualchars code fullscreen",
                "insertdatetime media nonbreaking save table contextmenu directionality",
                "emoticons template paste textcolor colorpicker textpattern"
            ],
            toolbar1: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image pastetext",
            toolbar2: "forecolor backcolor emoticons | fontselect | fontsizeselect | print preview code pagebreak media",
            image_advtab: true,
            templates: [
                {title: "Test template 1", content: "Test 1"},
                {title: "Test template 2", content: "Test 2"}
            ],
            forced_root_block : "",
            content_css : "css/custom_content.css",
            theme_advanced_font_sizes: "10px,12px,13px,14px,16px,18px,20px",
            font_size_style_values : "10px,12px,13px,14px,16px,18px,20px",
        });
        
        $("#address").keydown(function(){
            var geocoder =  new google.maps.Geocoder();
            geocoder.geocode({ \'address\': $(\'#address\').val()}, function(results, status) {
                $(\'#Marker_longitude\').val(results[0].geometry.location.lat());
                $(\'#Marker_latitude\').val(results[0].geometry.location.lng());                
            });
        });
        
        $("#Marker_icon").change(function(){
           $("#icon-preview").attr("src","' . $this->module->assetsUrl . '/images/icons/' . '" + $("#Marker_icon").val());
        });
        
        $(document).ready(function(){
           $("#icon-preview").attr("src","' . $this->module->assetsUrl . '/images/icons/' . '" + $("#Marker_icon").val()); 
        });
    ');
?>	
<div class="form">
<?php $form=$this->beginWidget('CActiveForm'); ?>
    <?php echo CHtml::errorSummary($model); ?>

    <div class="row">
        <?php echo CHtml::label('Type your address here', 'address'); ?>
        <?php echo CHtml::textField('address', '', array('class' => 'width-100pc')); ?>
    </div>
    
	<div class="row">
		<?php echo $form->labelEx($model,'longitude'); ?>
		<?php echo $form->textField($model,'longitude', array('class' => 'width-200')); ?>
		<?php echo $form->error($model,'longitude'); ?>
	</div>
	
	<div class="row">
		<?php echo $form->labelEx($model,'latitude'); ?>
		<?php echo $form->textField($model,'latitude', array('class' => 'width-200')); ?>
		<?php echo $form->error($model,'latitude'); ?>
	</div>

    <div class="row">
        <?php echo $form->labelEx($model,'icon'); ?>
        <?php echo $form->listBox($model,'icon',$icons,array('class' => 'width-200 height-200')); ?>
        <?php echo $form->error($model,'icon'); ?>
        <img id="icon-preview" src="" />  
    </div>
    
	<div class="row">
		<?php echo $form->labelEx($model,'text'); ?>
		<?php echo $form->textArea($model,'text', array('class' => 'width-100pc')); ?>
		<?php echo $form->error($model,'text'); ?>
	</div>
	
	<div class="row buttons center padding-20-0">
        <?php echo CHtml::submitButton('Save'); ?>
	</div>
	
	<?= CHtml::hiddenField('lang', Yii::app()->language) ?>
<?php $this->endWidget(); ?>

</div><!-- form -->