<?php
/**
 * Yii Google Maps markers
 *
 * @author Marc Oliveras Galvez <oligalma@gmail.com> 
 * @link http://www.ho96.com
 * @copyright 2015 Hosting 96
 * @license New BSD License
 */
 
class Marker extends CActiveRecord
{
    public $maxId = 0;
    	
	/**
	 * Returns the static model of the specified AR class.
	 * @return CActiveRecord the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{marker}}';
	}
	
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('longitude, latitude, text, icon', 'required'),
			array('text','filter','filter'=>array($obj=new CHtmlPurifier(),'purify')),
			array('longitude, latitude', 'numerical'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'longitude' => 'Longitude',
			'latitude' => 'Latitude',
			'text' => 'Text',
			'icon' => 'Icon',
		);
	}
    
    public static function getIcons()
    {
        $strpos = strpos(Yii::app()->controller->module->assetsUrl, 'assets');
        $assets = substr(Yii::app()->controller->module->assetsUrl, $strpos);
        
        $files = scandir($assets . '/images/icons');
        foreach ($files as $key => $value) {
            if ($value == '_license.txt' or $value == '.' or $value === '..' or is_dir($assets . '/images/icons/' . $value))
                unset($files[$key]);
        }
        $files = array_combine($files, $files);
        return $files;
    }
    
    protected function beforeSave()
    {
        if($this->scenario == 'insert')
        {
            $marker = Marker::model()->find(array('select' => 'MAX(id) as maxId'));
            $this->id = $marker->maxId + 1;
        }

        return true;
    }
}
