<?php
/**
 * Yii Google Maps markers
 *
 * @author Marc Oliveras Galvez <oligalma@gmail.com> 
 * @link http://www.ho96.com
 * @copyright 2015 Hosting 96
 * @license New BSD License
 */
 
class MarkerController extends CController
{
	public $layout = '//layouts/column1';

    public function actionIndex()
    {
        $markers = Marker::model()->findAll();        
        $this->render('index', array('markers' => $markers));
    }

    public function actionCreate()
    {
        $model = new Marker;
        
        if(isset($_POST['Marker']))
        {
            $model->attributes = $_POST['Marker'];
            if($model->save())
                $this->redirect(array('index'));
        }    
        
        $this->render('create', array('model' => $model, 'icons' => Marker::getIcons()));
    }
        	
	public function actionUpdate($id)
	{        
        $model = Marker::model()->findByPk($id);
        
        if(isset($_POST['Marker']))
        {
            $model->attributes = $_POST['Marker'];
            if($model->save())
                $this->redirect(array('index'));
        } 
       
        $this->render('update', array('model' => $model, 'icons' => Marker::getIcons()));   
	}

    public function actionDelete($id)
    {        
        $model = Marker::model()->findByPk($id);
        $model->delete(); 
        $this->redirect(array('index'));  
    }
}
