<?php

/**
 * Yii Google Maps markers
 *
 * @author Marc Oliveras Galvez <oligalma@gmail.com> 
 * @link http://www.ho96.com
 * @copyright 2015 Hosting 96
 * @license New BSD License
 */
 
class MarkersModule extends CWebModule{
	/*
	 * Add parameters here. You can access them using Yii::app()->controller->module->myParameter
	 */
	public $db;
    public $defaultController ="Marker";
	private $_assetsUrl;
	
    public function init()
    {
        $this->setImport(array(
                'markers.models.*',
        ));
		
        Yii::app()->setComponents(
        	array(
		       'db'=>array(
		           'class'=>'CDbConnection',
		           'tablePrefix' => 'tbl_',
		           'connectionString'=>'sqlite:'.dirname(__FILE__).'/data/markers.sqlite',
		       ),
			)
		);        
    }
	
	public function getAssetsUrl()
	{        
	    if ($this->_assetsUrl === null)
	        $this->_assetsUrl = Yii::app()->assetManager->publish(Yii::getPathOfAlias('markers.assets'));
		
	    return $this->_assetsUrl;
	}
}