<?php
/**
 * RezvanCaptcha class file.
 *
 * @author Rezvan Data Mining <info@dkr.co.ir>
 * @link http://www.dkr.co.ir/
 * @copyright Copyright &copy; 2013 faravaghi.ir
 */

/**
 * RezvanCaptcha is an extension to CCaptcha.
 * 
 * RezvanCaptcha can render a CAPTCHA image with non alphabetical characters while CCaptcha is only for alphabets.
 * 
 * RezvanCaptcha must be used together with RezvanCaptchaAction to provide its capability.
 *
 * RezvanCaptcha may render a button next to the CAPTCHA image. Clicking on the button
 * will change the type of the characters from non alphabetical to alphabetical
 * and vice versa.
 *
 * @author Mohammad Ebrahim Amini <faravaghi@gmail.com>
 */
class RezvanCaptcha extends CCaptcha
{
	/**
	 * @var boolean whether to show the button to change the character type.
	 * If false, the type of the characters is fixed to non alphabetical.
	 * If true, the user can select standard alphabetical characters.
	 * Defaults to true.
	 */
	public $showTypeChangeButton = true;

	/**
	 * @var type boolean whether to use inner CSS for image and the buttons.
	 * Defaults to true.
	 */
	public $useInnerCss = true;
	
	/**
	 * Renders the widget.
	 */
	public function run()
	{
		if(self::checkRequirements('imagick') || self::checkRequirements('gd'))
		{
			$this->renderImage();
			$this->registerClientScript();
		}
		else
			throw new CException(Yii::t('yii','GD with FreeType or ImageMagick PHP extensions are required.'));
	}

	/**
	 * Renders the CAPTCHA image.
	 */
	protected function renderImage()
	{
		if(!isset($this->imageOptions['id']))
			$this->imageOptions['id']=$this->getId();
		// set the default class for image and the buttons
		if(!isset($this->imageOptions['class']))
			$this->imageOptions['class']='RezvanCaptcha';
		if(!isset($this->buttonOptions['class']))
			$this->buttonOptions['class']='RezvanCaptcha';

		$url=$this->getController()->createUrl($this->captchaAction,array('v'=>uniqid()));
		$alt=isset($this->imageOptions['alt'])?$this->imageOptions['alt']:'';
		echo CHtml::image($url,$alt,$this->imageOptions);
	}

	/**
	 * Registers the nececssary client scripts.
	 */
	public function registerClientScript()
	{
		parent::registerClientScript();
	}

}
