<?php

class EMutex extends CApplicationComponent
{
	
	public $mutexPath;
	
	private $_locks = array();
	
	public function init()
	{
		
		parent::init();
		
		if (null === $this->mutexPath)
		{
			$this->mutexPath = Yii::app()->getRuntimePath();
		}
		
	}
	
	public function lock($id, $timeout = 0)
	{
		
		$path = $this->_getLockFilePath($id);
		
		$data = @unserialize(@file_get_contents($path));
		
		if (false !== $data && (0 === $data[0] || $data[0] + $data[1] > time()))
		{
			return false;
		}
		
		array_push($this->_locks, $id);

		file_put_contents($path, serialize(array($timeout, time())), LOCK_EX);

		return true;
		
	}
	
	public function unlock($id = null)
	{
		
		if (null === $id && null === ($id = array_pop($this->_locks)))
		{
			throw new CException("No lock available that could be unlocked. Make sure to setup a lock first.");
		}
		
		return @unlink($this->_getLockFilePath($id));
		
	}
	
	private function _getLockFilePath($id)
	{
		return "{$this->mutexPath}/" . md5($id) . '.lock';
	}
	
}

?>