<?php
//use the main-layout from mongocms
$this->beginContent('/layouts/main');
?>
<div class="container">
	<div class="span-18">
		<div id="content">
			<?php echo $content; ?>
		</div><!-- content -->
	</div>
	<div class="span-6 last">
		<div id="sidebar">
		<?php
		//Renders the result of the method 'getDashboardContent' from MongoCmsContentProvider
		//into the view '_contentlinks.php'  (= _WIDGETID)
		$this->widget('mongocms.components.MongoCmsContentPortlet',
						array(
								'id' => '_contentlinks',
								'title'=>MongoCmsModule::t('News'),
								'method'=>'getDashboardContent',
								'methodParams'=>array(
									       //static docroute @see config/mongocms/docroutes_dashcontent.php
									       'rootDocRoute'=>'dash_news',
									       'limit'=>10,
									       'attributes'=>array('_id','title'),
									    ),
							)
						);
		?>
		<?php
			//Renders the result of the method 'getUsersOnline' from MongoCmsContentProvider
			//into the view '_usersonline.php'  (= _WIDGETID)
			//Uses a cached output
			$expires = 60;
			$this->widget('mongocms.components.MongoCmsCachedContentPortlet',
							array(
									'duration' => $expires,
									'id' => '_usersonline',
									'title'=>MongoCmsModule::t('Now online'),
									'method'=>'getUsersOnline',
									'methodParams'=>array('delta'=>$expires)
								)
			    		);
		?>
		</div><!-- sidebar -->
	</div>
</div>
<?php $this->endContent(); ?>