<?php
/**
 * Renders the default dashboard into layouts/dashboard.php
 */

$this->breadcrumbs = array(
   MongoCmsModule::t('Dashboard'),
 );

?>
<h3><?php echo MongoCmsModule::t('User') . ': ' . Yii::app()->user->name; ?></h3>

<?php

	//display messages for the authenticated user
	$messageProvider = MongoCmsContentProvider::getDashboardContent('dash_message');
	if ($messageProvider->itemCount > 0)
	{
		echo CHtml::tag('h5',array(),MongoCmsModule::t('Messages'));

		$this->widget('zii.widgets.CListView', array(
				'dataProvider' => $messageProvider,
				'itemView' => '_index_message',
			  ));
	}
?>

<?php

//display tabs with user profile, my content and my favorites
$userModel = Yii::app()->mongocmsUser();
$userId = Yii::app()->user->id;

$profileUrl = $userModel->getActionItemUrl('view','user','',array('id'=>$userId));
$myContentUrl = Menu::getControllerActionUrl('dashboard','mycontent');
$myFavoritesUrl = Menu::getUserReferencesUrl(Reference::TYPE_FAVORITE);

$this->widget('zii.widgets.jui.CJuiTabs', array(
		'tabs'=>array(
		    MongoCmsModule::t('Profile')=>array('ajax'=>$profileUrl),
			MongoCmsModule::t('My content')=>array('ajax'=>$myContentUrl),
			MongoCmsModule::t('My favorites')=>array('ajax'=>$myFavoritesUrl),
		),
		// additional javascript options for the tabs plugin
		'options'=>array(
		    'collapsible'=>true,
		),

		'themeUrl' => Yii::app()->mongocmsUIThemeUrl(),
		'theme' => Yii::app()->mongocmsUITheme(),
));

//Render the pubished messages for the users role
//The corresponding view file is the 'id' with prefix '_'
/*
$this->widget('mongocms.components.MongoCmsDataWidget', array(
                'id' => 'index_messages', //renders the view '_index_message'
                'config'=>array('publishedOnly' => true),
        ));
*/
?>