<?php
//register metatags from page settings
if ($keywords = $data->getSettingsValue('metaKeywords'))
	Yii::app()->clientScript->registerMetaTag($keywords, 'keywords');

if ($description = $data->getSettingsValue('metaDescription'))
	Yii::app()->clientScript->registerMetaTag($description, 'description');
?>

<div id="page" class="view">
   	<h2><?php echo $data->title; ?></h2>
   	<?php if (!empty($data->subtitle)): ?>
     <h4><i><?php echo $data->subtitle; ?></i></h4>
    <?php endif; ?>
    <div id="tags">
    <span id="mprint" class="right">
	<?php
	//show print page if setting showPrintPage is set
	if ($data->getSettingsValue('showPrintPage'))
	  $this->widget('mongocms.extensions.mPrint.mPrint', array(
							'title' => $data->title,          //the title of the document. Defaults to the HTML title
							'tooltip' => MongoCmsModule::t('Print'),        //tooltip message of the print icon. Defaults to 'print'
							'text' => MongoCmsModule::t('Print page'),   //text which will appear beside the print icon. Defaults to NULL
							'element' => '#page',        //the element to be printed.
							'publishCss' => true,
							'exceptions' => array(       //the element/s which will be ignored
							  	'#header',
							  	'#myslidemenu',
							  	'#mprint',
							  	'#actions',
							  	'#footer',
							  ),
	                       ));



	?>
	</span>
    <?php
      //tags
      MongoCmsUtil::renderModelTagLinks($data,'Tags');
    ?>
    </div>
    <br/>
	<div class="content"><?php echo $data->body; ?></div>
	<div>
		<?php if ($data->getSettingsValue('showAuthor'))
			echo CHtml::tag('strong',array(), MongoCmsModule::t('Author')) . ': ' . $data->author .'&nbsp;';
		?>
		<?php if ($data->getSettingsValue('showCreated'))
			echo CHtml::tag('strong',array(), MongoCmsModule::t('Created')) . ': ' .
				    Yii::app()->dateFormatter->formatDateTime($data->created) .'&nbsp;';
		?>
		<?php if ($data->getSettingsValue('showModified'))
			echo CHtml::tag('strong',array(), MongoCmsModule::t('Modified')) . ': ' .
				    Yii::app()->dateFormatter->formatDateTime($data->modified) .'&nbsp;';
		?>
     </div>

	<?php if (!empty($data->externallinks)): ?>
	<div>
        <hr/>
      <h5><?php echo MongoCmsModule::t('Links'); ?></h5>
      <ul>
	<?php  foreach ($data->externallinks as $url => $label): ?>
	   <li>
		<?php
		  if (empty($label))
		  	$label = $url;
		  echo CHtml::link($label,$url,array('target'=>'_blank'));
		?>
		</li>
	<?php endforeach; ?>
	  </ul>
	 </div>
	 <br/>
    <?php endif; ?>

	 <?php if (!empty($data->attachments)): ?>
     <div>
        <hr/>
		<h5><?php echo MongoCmsModule::t('Attachments'); ?></h5>
		<?php MongoCmsUtil::listAttachmentsPage($this,$data); ?>
		<br/>
	 </div>
    <?php endif; ?>

  <div id="actions">
    <hr/>
	<?php
	  echo MongoCmsUtil::getModelCrudActionLink($data,'update', 'Edit','&raquo; ') . ' ';
	  MongoCmsUtil::userReferencesLink($data,Reference::TYPE_FAVORITE);
	?>
  </div>
</div>
