<h3><?php echo MongoCmsModule::t('Permissions'); ?></h3>
<?php
$form = $this->beginWidget('CActiveForm', array(
	'id' => 'permissions-form',
	'enableAjaxValidation' => false,
));

$roles= Yii::app()->mongocmsDefinedRoles();

$checkBoxList = array();
foreach($roles as $role => $label)
	$checkBoxList[$role] = '';


//global permissions: @see config/mongocms/roleoperations_mongocms.php

$authManager = Yii::app()->mongocmsAuthManager(); //loadFromDB

$operations = array();
$operationsObj = $authManager->getOperations();
foreach($operationsObj as $operationName => $authItem)
	$operations[$operationName] = $authItem->description;

$this->renderPartial('_form_permissions_mongocms', array(
        'roles' => $roles,
        'operations' => $operations,
        'checkBoxList' => $checkBoxList,
        'authManager' => $authManager,
        )
);



//see MongoCmsBehavior
$contentTypes = Yii::app()->mongocmsContentTypes();

foreach ($contentTypes as $modelClass => $modelClassLabel)
{
	$model = new $modelClass;
	$authManager = $model->getContenttypeAuthManager(); //loadFromDB

	$operations = array();
	$operationsObj = $authManager->getOperations();
	foreach($operationsObj as $operationName => $authItem)
		$operations[$operationName] = $authItem->description;

	$this->renderPartial('_form_permissions', array(
	        'modelClass' => $modelClass,
	        'modelClassLabel' => $modelClassLabel,
	        'roles' => $roles,
	        'operations' => $operations,
	        'checkBoxList' => $checkBoxList,
	        'authManager' => $authManager,
	        )
	);
}

echo '<div class="row buttons">';
echo CHtml::submitButton(MongoCmsModule::t('Save'));
echo '</div>';
$this->endWidget();

?>

