<?php

$actionCaption = $model->isNewRecord ? MongoCmsModule::t('Create') : MongoCmsModule::t('Update');

$this->breadcrumbs = array(
	    MongoCmsModule::t('Pages') => array('index'),
	    $model->title => array('view', 'id' => $model->_id),
	    $actionCaption,
    );

$modelClass = $model->getModelClass();

?>
<h1><?php echo $actionCaption . ' ' . MongoCmsModule::t($modelClass);?></h1>
<?php
$view = $model->getViewForm();
$form = $this->beginWidget('CActiveForm', array(
        'id' => 'page-form',
        'enableAjaxValidation' => false,
        'htmlOptions' => array('enctype' => 'multipart/form-data'),
        ));

echo '<div class="form">'; //because of css div.form .errorSummary
echo $form->errorSummary(array($model,$linkModel));
echo '</div>';
echo '<p class="note">Fields with <span class="required">*</span> are required.</p>';

$tabs = array();
$tabs[$modelClass] = array('title' => MongoCmsModule::t($modelClass),
    'view' => $model->getViewForm(),
    'data' => array('model' => $model, 'form' => $form),
    );

$pageSettingsForm = $model->createSettingsForm();
//$pageSettingsForm = MongoCmsUtil::createSearchForm();
if (!empty($pageSettingsForm)) {
	$tabs['Settings'] =  array('title' => MongoCmsModule::t('Settings'),
	      'view' => $model->getViewForm('settings'),
	      'data' => array('model' => $model, 'form' => $pageSettingsForm),
	    );
}

if ($model->hasEmbeddedDocuments())
    foreach ($model->embeddedDocuments() as $attribute => $className)
    $tabs[$attribute] = array('title' => MongoCmsModule::t($className),
        'view' => $model->getViewForm($attribute),
        'data' => array('model' => $model, 'form' => $form),
        );


if ($model->exposePermissions())
{
	$tabs['Permissions'] = array('title' => MongoCmsModule::t('Permissions'),
        'view' => $model->getViewForm('permissions_content'),
        'data' => array('model' => $model, 'form' => $form),
        );
}

$this->widget('CTabView', array('tabs' => $tabs));

echo '<div class="row buttons">';
echo CHtml::submitButton($actionCaption);
echo '</div>';
$this->endWidget();

?>