<?php
/**
 * Permissions form for a single item (Page, Menu, User ...)
 */

$modelClass = $model->getModelClass();

$roles = Yii::app()->mongocmsDefinedRoles(); //see MongoCmsBehavior
$checkBoxList = array();

foreach($roles as $role => $label)
	$checkBoxList[$role] = '';

$operations = $model->getContentAccessOperations();

?>
<h3><?php if (!empty($model->title))
	       echo MongoCmsModule::t('Permissions for') . ' ' . $model->title;
    ?>
</h3>
<p><?php
	echo MongoCmsModule::t('Leave all unchecked to skip access check for this node (only docroute and contenttype access will be checked).');
?>
</p>
<table>
  <tr>
    <th></th>
    <?php foreach($roles as $role => $label): ?>
	 <th><?php echo CHtml::encode(MongoCmsModule::t($label)); ?></th>
	<?php endforeach; ?>
  </tr>
 <?php foreach($operations as $operationName => $opDescription): ?>
  <tr>
    <td>
     <?php echo CHtml::encode($opDescription); ?>
    </td>
	<?php
		$name = $modelClass.'[permissions][roles]['.$operationName.']';
		$checkBoxSelected = array();
		foreach($roles as $role => $label) {
			$checked = $model->hasPermission($role,$operationName,$permissionsSet) && $permissionsSet;
			if ($checked) {
				$checkBoxSelected[]=$role;
			}
		}

		echo CHtml::checkBoxList($name,$checkBoxSelected,$checkBoxList,
			$htmlOptions=array(
			 'template' =>'<td>{input}</td>',
			 'separator' => '',
		));
     ?>
  </tr>
  <?php endforeach; ?>
</table>
