<?php

/**
 * Slideshow.php
 *
 * The model for the contenttype 'Slideshow'
 *
 * This model has one static docroute 'slideshow'
 * @see config/mongocms/docroutes_slideshow.php
 *
 * The imagepresets from the model Page are overridden
 * @see config/mongocms/imagepresets.php
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class Slideshow extends Page
{
	/**
	 * Returns the static model of the specified AR class.
	 *
	 * @return the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}


	/**
	 * Renders the slideshow into the tag with id=$outputId
	 *
	 * Prepare the images array for the slideshow
	 * images = array ('imageurl1' => 'description1',
	 *                 'imageurl2' => 'description2',
	 *                  ....),
	 *
	 * I don't know, how to add description field to CMultiFileUpload used in attachments.
	 * So the description will be empty.
	 *
	 * @param string $outputId
	 * @return
	 */
	public function renderSlideshow($outputId)
	{
		$images = array();
		$description = '';

		foreach ($this->getAttachmentImageUrls('slideshow') as $url)
			$images[$url] = $description;

		Yii::app()->controller->widget('mongocms.modules.slideshow.extensions.JShowcase', array(
						'outputId'=>$outputId,
						'images'=>$images,
	                  ));
	}


	/**
	 * Get the first active slideshow with attachments
	 *
	 * @return model Slideshow
	 */
	public static function getSlideshowModel()
	{
		$config = array(
						'modelclass' => 'Slideshow',
						'modelclassOnly' => true,
						'docRoute' => 'slideshow',
						'limit' => 1,
						'publishedOnly' => true,
					  );

		$dataProvider = new MongoCmsDataProvider($config);
		$data = $dataProvider->getData();

		if (is_array($data) && count($data))
		{
			$model = $data[0];
			if (count($model->attachments))
			   return $model;
		}

		return null;
	}


}
