<?php

/**
 * A wrapper for the jquery-plugin "showcase"
 *
 * @link http://plugins.jquery.com/project/showcase
 *
 * The links to documentation/demo/homepage of this jquery plugin are dead ...
 * Seams that this project is not supported in the future.
 * So I don't publish this extension in Yii framwork.
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class JShowcase extends CWidget{

	public $outputId; //id of the tag where to display the slideshow
	public $cssFile;

	/**
	 * $images = array ('imageurl1' => 'description1',
	 *                 'imageurl2' => 'description2',
	 *                  ....),
	 */
	public $images;

	//options
	public $navigator = array(
				        'autoHide' => true,
				        );
	public $animation = array(
	                    'autoCycle' => true,
	                    'stopOnHover' => true,
	                    'interval' => 3000,
	                    'speed' => 900,
	                    'easefunction' => 'swing',
	                    'type' => 'fade',
	              );

	public $titleBar = array(
			     'enabled' => false, //have no description yet: @see themes/mongocms/views/mongocms/slideshow/view
			     'autoHide' => false,
			   );

	protected $baseUrl;

	/**
	 * @return array the javascript options
	 */
	protected function getClientOptions()
	{
		static $properties=array('navigator','animation','titleBar');

		$options=array();
		foreach($properties as $property)
		{
			if($this->$property!==null)
				$options[$property]=$this->$property;
		}

		return $options;
	}


	/**
	 * Initializes the widget.
	 */
	public function init()
	{
		$dir = dirname(__FILE__) . DIRECTORY_SEPARATOR . 'assets';
		$this->baseUrl = CHtml::asset($dir);
        $this->id = $this->outputId;
		$this->registerClientScript();
	}

	/**
	 * Registers the needed CSS and JavaScript.
	 */
	public function registerClientScript()
	{
		if (!empty($this->images))
		{
			$id=$this->id;

			$acOptions=$this->getClientOptions();
			$acImages = $this->getImages();
			$options =  CJavaScript::encode(array_merge($acImages,$acOptions));

			$cs=Yii::app()->getClientScript();
			$cs->registerCoreScript('jquery');
			$cs->registerScriptFile($this->baseUrl.'/jquery.showcase-2.0.2.min.js');
			$cs->registerScript(__CLASS__.'#'.$id,'$(function(){$'."(\"#{$id}\").showcase($options);});", CClientScript::POS_END);
		}
	}


	/**
	 * Prepare imagelist for showcase javascript
	 *
	 * @return
	 */
	protected function getImages()
	{

		$imageList = array();
		if (!empty($this->images))
		{
			foreach ($this->images as $url => $description)
			{
				$imageList[] = array(
				                     'url'=>$url,
				                     'description'=>$description, //todo description ??
				                     );
			}
		}

		return array('images'=>$imageList);
	}
}

