<?php

/**
 * SlideshowModule.php
 *
 * An example for extending mongocms with own contenttypes
 * Custom contenttypes should be implemented as a submodule of the mongocms
 *
 * Important:
 * the submodule has to implement getContentTypes() to tell the mainmodule
 * which contenttypes it supports
 *
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class SlideshowModule extends MongoCmsModule
{
	public $defaultController = 'slideshow';

	/**
	 * The submodule has to tell which contenttypes it supports
	 * Don't call parent::getContentTypes here!
	 *
	 * @return array classname => label
	 */
	public function getContentTypes()
	{
		return array('Slideshow'=>'Slideshow');
	}

}
