<?php

/**
 * Role.php
 *
 * The model for handling user roles in the mongoDB
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class Role extends Page
{

	public function getCollectionName()
	{
		return 'mongocms_roles';
	}

	/**
	 * Returns the static model of the specified AR class.
	 *
	 * @return the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * No access control for each role
	 *
	 * @return boolean
	 */
	public function exposePermissions()
	{
		return false;
	}

	/**
	 * Override from parent
	 * No page settings for user supported
	 *
	 * @return CForm
	 */
	public function createSettingsForm()
	{
		return null;
	}


	/**
	 * Return the visible attributes in an action context
	 * This is used for lists (grid, index ...)
	 *
	 * @param mixed $scenario
	 * @return array
	 */
	public function getVisibleAttributes($actionId = null)
	{
		return array('title','subtitle','author','created');
	}


	/**
	 *
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
		    'title' => MongoCmsModule::t('RoleId'),
		    'subtitle' => MongoCmsModule::t('Description'),
		    'created' => MongoCmsModule::t('Created'),
		    'modified' => MongoCmsModule::t('Modified'),
		    );
	}

	/**
	 * Set role unique
	 *
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// don't forget to merge with parent rules
		return array_merge(parent::rules(), array(
		            array('title, subtitle', 'length', 'max' => 255),
					array('title', 'required'),
		            array('title', 'ext.YiiMongoDbSuite.extra.EMongoUniqueValidator','on' => 'insert'),
		        ));
	}

	/**
	 * Return the roles array (name => description)
	 *
	 * Fieldmap:
	 * title -> name
	 * subtitle -> description
	 *
	 * @return array
	 */
	public function getDefinedRoles()
	{
		$roles = array();
		$cursor = $this->getCollection()->find();

		if (!empty($cursor))
			foreach ($cursor as $id => $value)
				$roles[$value['title']] = $value['subtitle'];

		return $roles;
	}

}
