<?php

/**
 * Reference
 *
 * Used in Page to store an array of references to other documents
 * @see Page methods: behavior, addReference, removeReference
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class Reference extends EMongoEmbeddedDocument
{
	const TYPE_FAVORITE = 'favorite';
	const TYPE_FOLLOW = 'follow';
	const TYPE_COMMENT = 'comment';

	public $type;  //string: favorit, friend... (on reference to User)
	public $title;  //string: title of the referenced page
	public $id; //the MongoId _id  of the linked document
	public $modelclass; //the class of the linked document: maybe it is in another collection than page
	public $modified; //the modified value of the linked document: usage for 'follow'
	public $added; //the timestamp when added

	/**
	 * Returns the static model of the specified AR class.
	 *
	 * @return the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * Returns a link to the referenced page
	 *
	 * @param array $htmlOptions
	 * @return string
	 */
	public function getPageLink($htmlOptions = array())
	{
		return Page::model($this->modelclass)->getPageLink($this->title,$this->id,$htmlOptions);
	}
}
