<?php

/**
 * Person.php
 *
 * Embedded document of the model 'User'
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class Person extends EMongoEmbeddedDocument {
    public $fullname;
    public $additional;
    public $firstname;
    public $lastname;
    public $person_title;
    public $academic_title;
    public $salutation;
    public $email;
    public $homepage;
    public $phone;
    public $mobilephone;
    public $fax;
    public $dayofbirth;
    public $links;
    public $address;

    /**
     * Returns the static model of the specified AR class.
     *
     * @return the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    /**
     * Translated attribute labels
     *
     * @return
     */
    public function attributeLabels()
    {
        return array(
            'fullname' => MongoCmsModule::t('Full name'),
            'additional' => MongoCmsModule::t('Additional'),
            'firstname' => MongoCmsModule::t('Firstname'),
            'lastname' => MongoCmsModule::t('Lastname'),
            'person_title' => MongoCmsModule::t('Title'),
            'academic_title' => MongoCmsModule::t('Academic title'),
            'salutation' => MongoCmsModule::t('Salutation'),
            'email' => MongoCmsModule::t('Email'),
            'homepage' => MongoCmsModule::t('Homepage'),
            'links' => MongoCmsModule::t('Links'),
            'phone' => MongoCmsModule::t('Phone'),
            'mobilephone' => MongoCmsModule::t('Mobile phone'),
            'fax' => MongoCmsModule::t('Fax'),
            'dayofbirth' => MongoCmsModule::t('Day of birth'),
            );
    }
    /**
     *
     * @return array validation rules for model attributes.
     */

	public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
               array('firstname,lastname,email', 'length', 'max' => 80),
        );
    }

}
