<?php

/**
 * PageSettings.php
 * PageSettings is the data structure for the page settings
 * @see Page.createSettingsForm()
 *
 * @link http://www.yiiframework.com/doc/guide/1.1/en/form.builder
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class PageSettings extends CFormModel
{
	public $metaKeywords;
	public $metaDescription;
	public $showAuthor = true;
	public $showCreated = true;
	public $showModified = false;
	public $showPrintPage = true;
	public $showFavoritesLink = true;
	public $showFollowLink = true;
	public $allowComments = false;

	/**
	 * Declares the validation rules
	 */
	public function rules()
	{
		return array(
			array('metaKeywords,metaDescription', 'length', 'max' => 500),
			array('showAuthor,showCreated,showModified,showPrintPage,showFavoritesLink,showFollowLink,allowComments', 'boolean'),
		);
	}

	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
			'metaKeywords'=>MongoCmsModule::t('Metatags keywords'),
			'metaDescription'=>MongoCmsModule::t('Metatags description'),
			'showAuthor'=>MongoCmsModule::t('Show author'),
			'showModified'=>MongoCmsModule::t('Show modified'),
			'showPrintPage'=>MongoCmsModule::t('Show print page'),
			'showFavoritesLink'=>MongoCmsModule::t('Favorites link'),
			'showFollowLink'=>MongoCmsModule::t('Follow link'),
			'allowComments'=>MongoCmsModule::t('Allow comments'),
		);
	}
}
