<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'LoginController'.
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class LoginForm extends CFormModel
{
	public $username;
	public $password;
	public $rememberMe;

	/**
	 * Check for installation
	 * @todo Maybe implement an install action in AdminController
	 *
	 */
	public function init()
	{
		parent::init();
		if (Yii::app()->mongocmsModule()->autoInstall)
		    Yii::app()->mongocmsInstall();
	}

	/**
	 * Declares the validation rules.
	 * The rules state that username and password are required,
	 * and password needs to be authenticated.
	 */
	public function rules()
	{
		return array(
			// username and password are required
			array('username, password', 'required'),
			// rememberMe needs to be a boolean
			array('rememberMe', 'boolean'),
			// password needs to be authenticated
			array('password', 'authenticate'),
		);
	}

	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
			'rememberMe'=>MongoCmsModule::t("Remember me next time"),
			'username'=>MongoCmsModule::t("loginname"),
			'password'=>MongoCmsModule::t("password"),
		);
	}

	/**
	 * Authenticates the password and assign roles to Yii.user (by setState)
	 */
	public function authenticate($attribute,$params)
	{
		if(!$this->hasErrors())  // we only want to authenticate when no input errors
		{
			$identity=new MongoCmsUserIdentity($this->username,$this->password);
			$identity->authenticate();
			switch($identity->errorCode)
			{
				case MongoCmsUserIdentity::ERROR_NONE:
					$duration=$this->rememberMe ? 3600*24*30 : 0; // 30 days
					Yii::app()->user->login($identity,$duration);
					break;
				case MongoCmsUserIdentity::ERROR_UNKNOWN_IDENTITY:
				case MongoCmsUserIdentity::ERROR_PASSWORD_INVALID:
					$this->addError('username',MongoCmsModule::t('Invalid login.'));
					break;
			}
		}
	}
}
