<?php

/**
 * ExternalLink.php
 * ExternalLink is the data structure for links embedded in page form
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class ExternalLink extends CFormModel
{
	public $url;
	public $label;

	/**
	 * Declares the validation rules.
	 */
	public function rules()
	{
		return array(
			// @see components/GUrlValidator.php
			array('url', 'GUrlValidator'),
			array('url,label', 'length', 'max' => 250),
		);
	}

	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
			'url'=>MongoCmsModule::t('Url'),
			'label'=>MongoCmsModule::t('Linktext'),
		);
	}
}