<?php

/**
 * Address.php
 *
 * Embedded document of the model 'User'
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class Address extends EMongoEmbeddedDocument {
	public $type;  //person, company ...
	public $name;
	public $additional;
	public $city;
	public $street;
	public $country;
	public $countrycode;
	public $zipcode;
	public $phone;
	public $fax;
	public $email;
	public $homepage;
	public $links;
	public $longitude;
	public $latitude;


	/**
	 * Returns the static model of the specified AR class.
	 *
	 * @return the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 *
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
		         array('name, city, street', 'length', 'max' => 80),
		        );
	}

	/**
	 * Translated attribute labels
	 *
	 * @return
	 */
	public function attributeLabels()
	{
		return array(
			'type' => MongoCmsModule::t('Type'),
			'name' => MongoCmsModule::t('Name'),
			'additional' => MongoCmsModule::t('Additional'),
			'city' => MongoCmsModule::t('City'),
			'street' => MongoCmsModule::t('Street'),
			'countrycode' => MongoCmsModule::t('Country code'),
			'zipcode' => MongoCmsModule::t('Zip code'),
			'phone' => MongoCmsModule::t('Phone'),
			'fax' => MongoCmsModule::t('Fax'),
			'email' => MongoCmsModule::t('Email'),
			'homepage' => MongoCmsModule::t('Homepage'),
			'links' => MongoCmsModule::t('Links'),
			'longitude' => MongoCmsModule::t('Longitude'),
			'latitude' => MongoCmsModule::t('Latitude'),
		);
	}
}
