<?php

/**
 * Account.php
 *
 * Embedded document of the model 'User'
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class Account extends EMongoEmbeddedDocument
{
	public $root; //only one superuser
	public $loginname;
	public $password;
	public $verifypassword;


	/**
	 *
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
				 array('root', 'checkUniqueRoot'),
				 array('root', 'unsafe'),
				 array('loginname', 'checkUniqueLoginName'),
				 array('password', 'length', 'max'=>128, 'min' => 4,'message' => MongoCmsModule::t("Incorrect password (minimal length 4 symbols).")),
				 array('password', 'compare', 'compareAttribute'=>'verifypassword', 'message' => MongoCmsModule::t("Retype Password is incorrect.")),
				 array('loginname,password,verifypassword', 'safe', 'on' => 'insert, update',),
		    );
	}

	/**
	 * Check if the loginname exists, only if is new record
	 * Note: EMongoUniqueValidator doesn't work for EMongoEmbeddedDocument
	 *
	 * @param string $attribute
	 */
	public function checkUniqueLoginName($attribute) {

		$value = $this->{$attribute};
		if (empty($value))
			return;

		$collection = User::model()->getCollection();
		$criteria = array('account.loginname' => strtolower($value));

		//is update: check all other records
		if (!empty($this->owner->_id))
			$criteria['_id'] = array('$ne' =>  new MongoID($this->owner->_id));

        if ($collection->count($criteria) > 0)
        	$this->addError('loginname',MongoCmsModule::t('Loginname ist not unique, please try another one.'));
	}


	/**
	 * Check only one root account allowed
	 * Note: EMongoUniqueValidator doesn't work for EMongoEmbeddedDocument
	 *
	 * @param string $attribute
	 */
	public function checkUniqueRoot($attribute) {

		$value = $this->{$attribute};
		if (empty($value))
			return;

		$collection = User::model()->getCollection();
		$criteria = array('account.root' => $value);

		//is update: check all other records
		if (!empty($this->owner->_id))
			$criteria['_id'] = array('$ne' =>  new MongoID($this->owner->_id));

		if ($collection->count($criteria) > 0)
			$this->addError('root',MongoCmsModule::t('Only one root account allowed.'));
	}


	/**
	 * Translated attribute labels
	 *
	 * @return
	 */
	public function attributeLabels()
	{
		return array(
			'loginname' => MongoCmsModule::t('Login name'),
			'password' => MongoCmsModule::t('Password'),
			'isadmin' => MongoCmsModule::t('Admin'),
		);
	}

	public function validatePassword($password)
	{
		//todo: salt;
		return $this->hashPassword($password)===$this->password;
	}

	public static function hashPassword($password,$salt='')
	{
		return md5($salt.$password);
	}


	/**
	 * Generates a salt that can be used to generate a password hash.
	 * @return string the salt
	 */
	protected static function generateSalt()
	{
		return md5(uniqid().microtime());
	}


}
