<?php

/**
 * UserController.php
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */

Yii::import('mongocms.models.*');
Yii::import('mongocms.controllers.AdminController');

/**
 * UserController
 *
 * @package
 * @author joe
 * @copyright Copyright (c) 2011
 * @version $Id$
 * @access public
 */
class UserController extends AdminController
{
    public $defaultAction = 'admin';
	//use the layout from main module montocms
	//public $layout = 'column1';


	/**
	 * Have to assign the module in __construct
	 * if loaded directly from controllerMap
	 *
	 * @param string $id
	 * @param string $module
	 */
	public function __construct($id, $module = null)
	{
		if (!isset($module))
			$module = Yii::app()->mongocmsModule();

		parent::__construct($id, $module);
	}

	/**
	 * Important:
	 * We have to override loadModel, because the model 'User' is
	 * stored in another collection than the model Page
	 * @see model User->getCollectionName()
	 *
	 * @param integer $ the ID of the model to be loaded
	 */
	public static function loadModel($id)
	{
		$model = User::model()->findByPk(new MongoID($id));
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');

		return $model;
	}


	/**
	 * Override method from AdminController to handle the password
	 *
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		//check operation updateAny OR updateOwn
		//have to add 'update' because of checking docroute 'update'!
		$model->checkAccess(array('update','updateAny','updateOwn'),array('model'=>$model));

		$modelClass = $model->getModelClass();

		$linkModel = new ExternalLink;

		if (isset($_POST[$modelClass])) {

			$attributes = $_POST[$modelClass];

			// add the values from the embedded values of the form
			foreach ($model->embeddedDocuments() as $doc => $embModelClass)
			{
				if (isset($_POST[$embModelClass]))
					$attributes[$doc] = $_POST[$embModelClass];
			}

			$storedPW = $model->account->password;
			$model->attributes = $attributes;

			//assign the settings from PageSettings
			$model->settings = $_POST['PageSettings'];

			//assign the links from PageLinks
			if (($linksValid = $this->validateExternalLinks($linkModel,$externalLinks)) !== false)
				$model->externallinks = $externalLinks;

			//we don't display the password in the form
			//don't override the stored password if empty and not set new
			if (isset($model->account->password) && empty($model->account->password))
			{
				$model->initSoftAttribute('storedPW'); //@see User.beforeSave
				$model->storedPW = $storedPW;
			}

			if ($linksValid && $model->save()) {
				$this->redirect(array('admin'));
			}
			// $this->redirect(array('view', 'id' => $model->_id));
		}

		//don't render the password into the form
		$model->account->password = '';
		$model->account->verifypassword = '';

		$this->render($model->getView('edit'), array(
		        'model' => $model,
		        'linkModel' => $linkModel, //for errorSummary
		        ));
	}


	/**
	 * Manages all users.
	 * The AdminController from main module will do the work
	 */
	public function actionAdmin()
	{
		parent::actionAdmin('User');
	}


	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		parent::actionIndex('User');
	}

	/**
	 * Create models.
	 */
	public function actionCreate()
	{
		parent::actionCreate('User');
	}

	/**
	 * Renders the loginform
	 *
	 * @return
	 */
	public function actionLogin()
	{
		if (Yii::app()->user->isGuest)
		{
			$model=new LoginForm;
			// collect user input data
			if(isset($_POST['LoginForm']))
			{
				$model->attributes=$_POST['LoginForm'];
				// validate user input and redirect to previous page if valid
				if($model->validate())
					  $this->redirect(Yii::app()->user->returnUrl);
			}
			// display the login form
			$this->render('login',array('model'=>$model,));
		} else
			$this->redirect(Yii::app()->user->returnUrl);
	}

	/**
	 * Logout the current user and redirect to returnLogoutUrl.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout();
        $url = Menu::getControllerActionUrl('content');
		$this->redirect($url);
	}

	/**
	 * Depending on $action:
	 *  - Add/Remove users references and display remove or add link
	 *    This is the action for ajax response
	 *
	 *  - List referereced items for the current user
	 *
	 *
	 * @see MongoCmsUtil.renderUserReferencesLink
	 *
	 *
	 * @param string $action one of 'list','add','remove','removelist'
	 * @param string $itemid: the _id of the document  to add,remove,removelist
	 * @param string $type: the type of the reference 'favorite', 'follow' ... @see Reference.php
	 * @param string $modelclass: the modelclass of the referenced item
	 * @param string $title: the title of the referenced item
	 * @param integer $modified: the modified timestampe of the referenced item
	 * @return
	 */
	public function actionReferences($action,
			$itemid = null,
			$type = null,
			$modelclass = null,
			$title = null,
			$modified = null
		)
	{
		$user = Yii::app()->mongocmsUser(true);

		// --- list references
		if ($action == 'list')
		{
		    $dataProvider = MongoCmsContentProvider::getUserReferences($type);
			//if embedded as ajax
			if (Yii::app()->request->isAjaxRequest)
				$this->renderPartial('references_'.strtolower($type), array(
			        'dataProvider' => $dataProvider,
			    ));
			else
				$this->render('references_'.strtolower($type), array(
			        'dataProvider' => $dataProvider,
			    ));
		}
		else
			//ajaxresponse add or remove
			if (Yii::app()->request->isAjaxRequest && !Yii::app()->user->isGuest)
			{
				if ($action == 'add')
				{
					$user->addReference($title, $type, $itemid, $modelclass,$modified);
					// removelink
					MongoCmsUtil::renderUserReferencesLink('remove', $itemid,
						                                          $type, $modelclass, $title,$modified);

				}elseif ($action == 'remove')
				{
					$user->removeReference($itemid);
					// addlink
					MongoCmsUtil::renderUserReferencesLink('add', $itemid,
						$type, $modelclass, $title,$modified);

				}elseif ($action == 'removelist')
				{
					$user->removeReference($itemid);
					echo CHtml::script('location.reload();'); // refresh list page
				}
				Yii::app()->end();
			}
	}

}
