<?php

/**
 * RoleController
 * The controller to administer the role model
 * Edit captions and set permissions
 *
 * The abstract base class for MongoCmsContentAccessFilter and MongoCmsMenuAccessFilter
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
Yii::import('mongocms.controllers.AdminController');

class RoleController extends AdminController
{
	public $defaultAction = 'admin';


	/**
	 * Have to assign the module in __construct
	 * if loaded directly from controllerMap
	 *
	 * @param string $id
	 * @param string $module
	 */
	public function __construct($id, $module = null)
	{
		if (!isset($module))
			$module = Yii::app()->mongocmsModule();

		parent::__construct($id, $module);
	}

	/**
	 * Manages all models.
	 * This is the default action set in AdminController
	 */
	public function actionAdmin()
	{
		parent::actionAdmin('Role');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		parent::actionIndex('Role');
	}

	/**
	 * Create all models.
	 * No support for creating menu items in this release
	 * All items will be created afterSave of a Page
	 *
	 */
	public function actionCreate()
	{
		parent::actionCreate('Role');
	}

	/**
	 * Important:
	 * We have to override loadModel, because the model 'Menu' is
	 * stored in another collection than the model Page
	 * @see model Menu->getCollectionName()
	 *
	 * @param integer $ the ID of the model to be loaded
	 */
	public static function loadModel($id)
	{
		$model = Role::model()->findByPk(new MongoID($id));
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');

		return $model;
	}
}