<?php

/**
 * MenuController
 * The controller to administer the menu model
 * Edit captions and set permissions
 *
 * The abstract base class for MongoCmsContentAccessFilter and MongoCmsMenuAccessFilter
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
Yii::import('mongocms.controllers.AdminController');

class MenuController extends AdminController
{
	public $defaultAction = 'admin';


	/**
	 * Have to assign the module in __construct
	 * if loaded directly from controllerMap
	 *
	 * @param string $id
	 * @param string $module
	 */
	public function __construct($id, $module = null)
	{
		if (!isset($module))
			$module = Yii::app()->mongocmsModule();

		parent::__construct($id, $module);
	}

	/**
	 * Manage all models
	 */
	public function actionAdmin()
	{
		parent::actionAdmin('Menu');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		parent::actionIndex('Menu');
	}

	/**
	 * Create all models.
	 */
	public function actionCreate()
	{
		parent::actionCreate('Menu');
	}

	/**
	 * @param integer $ the ID of the model to be loaded
	 */
	public static function loadModel($id)
	{
		$model = Menu::model()->findByPk(new MongoID($id));
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');

		return $model;
	}

}
