<?php

/**
 * Files from attachments: download or view
 * The FileController have to be registered in config/main.php in controllerMap
 * 'file'=>'application.modules.mongocms.controllers.FileController'
 *
 * The links were generated in Page -> downloadAttachmentLink / viewAttachmentUrl
 * @see Page
 * @see MongoCmsFileWidget
 *
 * FILE_ID = _id of the file from the collection mongocms_file
 *
 * Url for download attachments from page:
 * /files/download/fid/FILE_ID
 *
 * Url for viewing file (image ...):
 * /files/view/fid/FILE_ID
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */

Yii::import('mongocms.components.MongoCmsFile');
Yii::import('mongocms.components.MongoCmsController');

class FileController extends MongoCmsController {

	public $defaultAction = 'download';

	/**
	 * When called from controllerMap (@see config/main.php) module is null
	 * But we need the config variables of the module
	 *
	 * @param mixed $id
	 * @param mixed $module
	 */
	public function __construct($id, $module = null)
	{
		if (!isset($module))
			$module = Yii::app()->mongocmsModule();

		parent::__construct($id, $module);
	}

    /**
     * This is the action to handle external exceptions.
     */
    public function actionError()
    {
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest)
                echo $error['message'];
            else
                $this->render('error', $error);
        }
    }

    /**
     * Load the page, check access, load the file
     *
     * @return bytestream of the file
     */
    protected function loadFile($fileId)
    {
		if (empty($fileId))
            return false;

    	$file = MongoCmsFile::model()->findByPk(new MongoID($fileId));

    	if (!(isset($file)))
    		return false;

    	if (!($file instanceof MongoCmsFile))
    		return false;

    	//check file access
    	if (!$file->checkAccess(true))
    		return false;

        return $file;
    }

    /**
     * Load attachment file and send it to the browser with download headers
     */
    public function actionDownload()
    {
        if (!$file = $this->loadFile($_GET['fid']))
            die(); //throw new CHttpException(404, 'Not Found.');

        self::sendDownloadData($file->orgfilename,
					            $file->getBytes(),
					            $file->metadata['size'],
					            $file->metadata['type']
					            );
    }

    /**
     * Load attachment file and send it to the browser
     */
    public function actionView()
    {
		if (!$file = $this->loadFile($_GET['fid']))
			die(); //throw new CHttpException(404, 'Not Found.');

        $this->sendData($file->getBytes(),
			            $file->metadata['size'],
			            $file->metadata['type']
                       );
    }

    /**
     * Sends attachment data with headers to enforce download
     *
     * @param string $filename
     * @param string databytes
     */
    public static function sendDownloadData($filename, $data, $size, $contenttype = 'application/octet-stream')
    {
        // Check filename
        if (empty($filename))
            return false;
        // Create download file name to be displayed to user
        $saveasname = basename($filename);
        // Send binary filetype HTTP header
        header('Content-Type: ' . $contenttype);
        // Send content-length HTTP header
        header('Content-Length: ' . $size);
        // Send content-disposition with save file name HTTP header
        header('Content-Disposition: attachment; filename="' . $saveasname . '"');
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        // Output file
        die($data);
    }

    /**
     * Sends attachment data to the browser
     *
     * @param string $filename
     * @param string databytes
     */
    public static function sendData($data, $size, $contenttype)
    {
		header('Content-Type: ' . $contenttype);
    	// Send content-length HTTP header
    	header('Content-Length: ' . $size);
        // Output file
    	die($data);
    }
}
