<?php

/**
 * MenuController
 * The controller to administer the menu model
 * Edit captions and set permissions
 *
 * The abstract base class for MongoCmsContentAccessFilter and MongoCmsMenuAccessFilter
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
Yii::import('mongocms.controllers.AdminController');

class DocrouteController extends AdminController
{
	public $defaultAction = 'admin';


	/**
	 * Have to assign the module in __construct
	 * if loaded directly from controllerMap
	 *
	 * @param string $id
	 * @param string $module
	 */
	public function __construct($id, $module = null)
	{
		if (!isset($module))
			$module = Yii::app()->mongocmsModule();

		parent::__construct($id, $module);
	}

	/**
	 * Manages all models.
	 * This is the default action set in AdminController
	 */
	public function actionAdmin()
	{
		parent::actionAdmin('DocRoute');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		parent::actionIndex('DocRoute');
	}

	/**
	 * Create all models.
	 * No support for creating menu items in this release
	 * All items will be created afterSave of a Page
	 *
	 */
	public function actionCreate()
	{
		parent::actionCreate('DocRoute');
	}

	/**
	 * Important:
	 * We have to override loadModel, because the model 'Menu' is
	 * stored in another collection than the model Page
	 * @see model Menu->getCollectionName()
	 *
	 * @param integer $ the ID of the model to be loaded
	 */
	public static function loadModel($id)
	{
		$model = DocRoute::model()->findByPk(new MongoID($id));
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');

		return $model;
	}

	/**
	 * Ajax response for formelement 'docroute'
	 * @see MongoCmsUtil::docrouteFormElements
	 *
	 * @return
	 */
	public function actionFormElements()
	{
		if (Yii::app()->request->isAjaxRequest)
		{

            $modelClass = $_GET['modelclass'];
			$id = $_GET['id'];

			$model =  empty($id) ? Page::model($modelClass)
				                 : Page::model($modelClass)->findByPk(new MongoID($id),
				                    array('select'=>array('_id','docroute'))); //lightweight


			if (!empty($_POST)) //on dropdown change: $_POST
				$selectedDocRouteId = $_POST['select_docrouteid'];
			else
			   $selectedDocRouteId = $_GET['docrouteid'];  //first call

			if (!empty($selectedDocRouteId))
			{
				$docRoutePrefixes = Menu::model()->getDocRoutes($selectedDocRouteId);

  				//dropdown for docroutes
				if (!empty($docRoutePrefixes))
				{
                	$docRoutesData = CHtml::listData($docRoutePrefixes, 'docroute', 'docroute');
                	echo CHtml::activeLabelEx($model, 'docroute');

					$docRoutePrefixName = $modelClass.'[' . DocRoute::DOCROUTE_PREFIX_ATTR .']';
					$selectedPrefix = null;

					//if is update find selected prefix: docroute is in dropdown
					if (!empty($model->docroute))
                	{
						$selectedPrefix = $model->docroute;
						$model->docroute = '';
                	}

					echo CHtml::dropDownList($docRoutePrefixName,$selectedPrefix,$docRoutesData);
					echo ' / ' . CHtml::activeTextField($model,'docroute');

                	Yii::app()->end();
                }
			}

			echo CHtml::activeLabelEx($model, 'docroute');
			echo CHtml::activeTextField($model,'docroute');

			Yii::app()->end();
		} else {
			throw new CHttpException(400, 'Invalid request.');
		}
	}


	/**
	 * Ajax response for formelement 'docroute' when creating menu
	 * @see MongoCmsUtil::docrouteFormElementsCreateMenu
	 *
	 * @return
	 */
	public function actionFormElementsCreateMenu()
	{
		if (Yii::app()->request->isAjaxRequest)
		{
			$model = new Menu;

			if (!empty($_POST['select_existingdocroute']))
			{
				if (($cursor = $model->getDocRoutesOnly()) !== false && $cursor->count())
				{
					$data = CHtml::listData($cursor, 'docroute', 'docroute');
					echo CHtml::activeLabelEx($model, 'docroute');
					echo CHtml::dropDownList('Menu[docroute]', '', $data);
					Yii::app()->end();
				}
			}

			echo CHtml::activeLabelEx($model, 'docroute');
			echo CHtml::activeTextField($model,'docroute');

			Yii::app()->end();
		} else {
			throw new CHttpException(400, 'Invalid request.');
		}
	}

	/**
	 * View the sitemap of the content
	 * $clickPath is the path where to go when an item is clicked
	 */
	public function actionMenuTree()
	{
		$model = Yii::app()->mongocmsDocRoute();

		$data = $model->byItemCollectionName('mongocms_content')->findAll();

		$clickPath = Yii::app()->mongocmsIndexRoute();
        $fullExpanded = true;

		$treeViewItems = array(
		    array(
		        'text' => MongoCmsModule::t(Yii::app()->name),
		        'id' => 'id_sitemap',
		        'expanded' => $fullExpanded,
		        'children' => $model->getTreeViewItems($data, $clickPath,$fullExpanded),
		        )
		);

		$this->render($model->getView('sitemap'), array(
                  'siteMapType' => 'Content',
				  'data' => $treeViewItems,
                ));
	}


	/**
	 * View the sitemap of the users
	 * $clickPath is the path where to go when an item is clicked
	 */
	public function actionUsergroups()
	{
		$model = Yii::app()->mongocmsDocRoute();

		$group = empty($_GET['type']);
		$data = $model->byItemCollectionName('mongocms_user')->findAll();

		$clickPath = '/mongocms/user/user';
		$fullExpanded = true;

		$treeViewItems = array(
		    array(
		        'text' => MongoCmsModule::t(Yii::app()->name),
		        'id' => 'id_sitemap',
		        'expanded' => $fullExpanded,
		        'children' => $model->getTreeViewItems($data, $clickPath,$fullExpanded),
		        )
		);

		$this->render($model->getView('sitemap'), array(
                  'siteMapType' => 'User',
				  'data' => $treeViewItems,
                ));
	}

}
