<?php

/**
 * DashboardController.php
 *
 * This controller provides the content for dashboard of authenticated users
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class DashboardController extends MongoCmsController
{
	public $defaultAction = 'index';

	public $layout = 'dashboard';


	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to access all actions
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Renders the dashboard
	 */
	public function actionIndex()
	{
		$this->render('index');
	}

	/**
	 * Find content where the currend user is the owner
	 */
	public function actionMyContent()
	{
		$dataProvider = MongoCmsContentProvider::getMyContent();

		//if embedded as ajax in tabview
		if (Yii::app()->request->isAjaxRequest)
			$this->renderPartial('mycontent', array(
		           'dataProvider' => $dataProvider,
		        ));
		else
			$this->render('mycontent', array(
			           'dataProvider' => $dataProvider,
			        ));

	}
}

