<?php

/**
 * ContentController.php
 *
 * This controller provides the content for the frontpage
 *
 * IMPORTANT to know:
 *
 * We call this controller directly through 'index' of controllerMap
 * That means:
 * - $this->module will not be set, we do it in __construct
 * - The viewPath of this controller is set to 'index', because it's the key in the controllerMap
 *    So if you change the key in the controllerMap, you have to rename the view directory too
 *    In __construct it is readonly, maybe needs work ....
 *
 *
 * Access to the docroute of the generated pages
 * Searchparams can be added
 * /index/content/DOCROUTE
 * The DOCROUTE is the docroute saved with the page
 *
 * There is no layout assigned, so the layout of the application will be used
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */

Yii::import('mongocms.models.*');
Yii::import('mongocms.controllers.AdminController');

class ContentController extends AdminController {
    public $defaultAction = 'index';

	public $layout = 'column1';

    //uncomment this to use the layout from site
    //public $layout = '//layouts/column1';

    /**
     * Have to assign the module in __construct
     *
     * @param string $id
     * @param string $module
     */
    public function __construct($id, $module = null)
    {
        if (!isset($module))
            $module = Yii::app()->mongocmsModule();

        parent::__construct($id, $module);
    }

    /**
     * Renders the public frontpage
     * Find all published content with 'view' access allowed
     */
    public function actionIndex()
    {
        $this->layout = 'frontpage';
		$this->render('index');
    }

	/**
	 * Manages all users.
	 * The AdminController from main module will do the work
	 */
	public function actionAdmin()
	{
		parent::actionAdmin('Content');
	}

	/**
	 * Create models.
	 */
	public function actionCreate()
	{
		parent::actionCreate('Content');
	}


	/**
	 * Renders the pages of a specific docroute
	 * If id is submitted as get param, the single page is rendered
	 *
	 * @return
	 */
	public function actionPage()
	{
		//extract the docroute from request
		$docroute = trim(str_replace($this->id .'/page/', '',
			                         Yii::app()->request->pathInfo), '/');
		$criteria = array();

		$config = array(
		          'publishedOnly' => true,
		         );

		$id = $_GET['id'];
		if (!empty($_GET['id']))
		{
			$config['criteria'] = array('_id' => new MongoId($id));
			$config['modelclass'] = $_GET['modelClass'];
		}
		else
		   $config['docRoute'] = $docroute;

		$dataProvider = new MongoCmsDataProvider($config);

		$this->render('page', array(
                    'dataProvider' => $dataProvider,
                ));
	}


	/**
	 * Renders the page view for a specific tag
	 */
	public function actionTag()
	{
        $tag = $_GET['tag'];
		if (!empty($tag))
		{
		  $dataProvider = MongoCmsContentProvider::getTaggedContent($tag);
		  $this->render('page', array(
							'dataProvider' => $dataProvider,
						));
		}
	}


	/**
	 * Renders the page view for a specific tag
	 */
	public function actionSearch()
	{
		$form = MongoCmsUtil::createSearchForm();

		if($form->submitted('search') && $form->validate())
		{
			$dataProvider = MongoCmsContentProvider::getKeywordContent($form->model->keywords);
			$this->render('page', array(
								'dataProvider' => $dataProvider,
								'searchKeywords' => $form->model->keywords,
	                        ));
		}
		else
			$this->render('search', array('form'=>$form));
	}

}
