<?php

/**
 * Install the operations for the contenttype 'User'
 * This file is included in Page.createDefaultContenttypePermissions
 *
 * The roles will be created by calling addRoleOperations or addRoleOperationsAll
 * The operations have to match the checkAccess within the action methods of the UserController
 *
 */

//Important to define operations first, before add to roles
$authManager->createOperation('view', MongoCmsModule::t('View'));
$authManager->createOperation('create', MongoCmsModule::t('Create'));
$authManager->createOperation('manage', MongoCmsModule::t('Manage'));

$authManager->createOperation('updateOwn', MongoCmsModule::t('Edit own'), MongoCmsAuthManager::bizRuleSameOwner());
$authManager->createOperation('updateAny', MongoCmsModule::t('Edit any'));

$authManager->createOperation('deleteOwn', MongoCmsModule::t('Delete own'), MongoCmsAuthManager::bizRuleSameOwner());
$authManager->createOperation('deleteAny', MongoCmsModule::t('Delete any'));


//add operations to roles
$authManager->addAuthenticatedRoleOperations(array('view','updateOwn','deleteOwn'));

//$authManager->addRoleOperations('editor',array('view','updateOwn','deleteOwn'));

$authManager->addRoleOperations('sitemaster',
array('view','create',
      'updateOwn','updateAny',
      'deleteOwn','manage')
   );

$authManager->addRoleOperationsAll('admin');
