<?php

/**
 * Install the operations for the contenttype 'Page'
 * This file is included in Page.createDefaultContenttypePermissions
 *
 * The roles will be created by calling addRoleOperations or addRoleOperationsAll
 * The operations have to match the checkAccess within the action methods of the (Admin)Controller
 *
 */

//Important to define operations first, before add to roles
$authManager->createOperation('view', MongoCmsModule::t('View'));
$authManager->createOperation('create', MongoCmsModule::t('Create'));
$authManager->createOperation('manage', MongoCmsModule::t('Manage'));

$authManager->createOperation('updateAny', MongoCmsModule::t('Edit any'));
$authManager->createOperation('updateOwn', MongoCmsModule::t('Edit own'), MongoCmsAuthManager::bizRuleSameOwner());

//Allow update if the user has at least one role of the content creators role
$authManager->createOperation('updateSameRole', MongoCmsModule::t('Edit same role'), MongoCmsAuthManager::bizRuleSameUserRole());

//Allow update if the user is the same usertype as the creator (means the user->docroute is the same)
$authManager->createOperation('updateSameUsertype', MongoCmsModule::t('Edit same usertype'), MongoCmsAuthManager::bizRuleSameUsertype());

$authManager->createOperation('deleteOwn', MongoCmsModule::t('Delete own'), MongoCmsAuthManager::bizRuleSameOwner());
$authManager->createOperation('deleteAny', MongoCmsModule::t('Delete any'));
$authManager->createOperation('deleteSameRole', MongoCmsModule::t('Delete same role'), MongoCmsAuthManager::bizRuleSameUserRole());
$authManager->createOperation('deleteSameUsertype', MongoCmsModule::t('Delete same usertype'), MongoCmsAuthManager::bizRuleSameUsertype());

//add operations to roles
$authManager->addGuestRoleOperations(array('view'));
$authManager->addAuthenticatedRoleOperations(array('view'));


$authManager->addRoleOperations('editor',
array('view','create','manage',
      'updateOwn','updateSameRole','deleteOwn',
      ));


$authManager->addRoleOperations('sitemaster',
array('view','create',
      'updateOwn','updateAny',
      'deleteOwn','deleteAny',
      'manage',
      ));

$authManager->addRoleOperationsAll('admin');
