<?php

/**
 * Build the mainmenu
 *
 * Don't translate labels when calling static Menu methods
 * The labels will be translated within the method
 */

// check for cached menu
if (Yii::app()->mongocmsModule()->enableMenuCache)
{
	if (($items = Yii::app()->mongocmsMenuFromCache(Menu::MAIN)) !== false)
		return $items;
}

$menuItems = array();

// Home: defaultAction from FrontController
$menuItems[] = Menu::getControllerDefaultActionItem('content','Home');

// menu items for authenticated users
if (!Yii::app()->user->isGuest)
{
    $userId = Yii::app()->user->id;
    $userModel = Yii::app()->mongocmsUser();
    $userId = $userModel->_id;

    if (!empty($userModel)) // user is not deleted in this moment
    {
    	// Dashboard: defaultAction from DashboardController
    	$menuItems[] = Menu::getControllerDefaultActionItem('dashboard','Dashboard');
    	$menuItems[] = Menu::getControllerActionItem('content','search','Search');

    	//Add 'Manage' as root item: exlude User,Role,DocRoute,Menu
    	$manageItems = Menu::getManageItems('Manage',array('User','Role','DocRoute','Menu'));
    	if (!empty($manageItems))
    		$menuItems[] = $manageItems;

    	//Add 'Administer' as root item: include User,Role,DocRoute,Menu
    	$administerItems = Menu::getManageItems('Administer',array(), array('User','Role','DocRoute','Menu'));
    	$administerItems['items'][] = Menu::getAdminCmsItem('permissions','managePermissions','Permissions');
    	$administerItems['items'][] = Menu::getAdminCmsItem('recreatepermissions','recreatePermissions','Recreate permissions');
    	$administerItems['items'][] = Menu::getAdminCmsItem('importdata','importData','Import data');

    	if (!empty($administerItems))
    		$menuItems[] = $administerItems;

		//collect items for MyData
    	//uncomment to add this items to mainmenu
    	/*
	        $myItems = array();

	        $profileUpdateItem = Menu::getActionItem($userModel, 'update',$userId, 'Profile');
	        $profileUpdateItem['visible'] = $userModel->checkAccess('updateOwn', array('userid' =>$userId),true);

	        //add my profile
	        $myItems[] = $profileUpdateItem;

	        //add my favorites
	        $myItems[] = Menu::getUserReferencesListItem(Reference::TYPE_FAVORITE, 'Favorites');

	        // Mycontent action from DashboardController
	        $myItems[] = Menu::getControllerActionItem('dashboard', 'mycontent', 'My content');

	    	//Add MyData as root item
	        if (!empty($myItems))
	            $menuItems[] = array('label'=>'My data','url' =>'#','items'=>$myItems);
        */
    }
}

//The dynamically created menuitems from main menu
//Add all items from docrouteid starting with Menu::MAIN
Menu::model()->addItems($menuItems);

//Add Logout as root item
$menuItems[] = Menu::getLogoutItem();
//Add Login as root item
$menuItems[] = Menu::getLoginItem();



// cache this menu depending on current user roles
if (Yii::app()->mongocmsModule()->enableMenuCache)
   Yii::app()->mongocmsMenuToCache(Menu::MAIN, $menuItems);
return $menuItems;
