<?php

/**
 * MongoCmsUserIdentity.php
 * Authentication handling
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class MongoCmsUserIdentity extends CUserIdentity
{
    private $_id;
	private $_name;

	/**
	 * Called by LoginForm.authenticate
	 *
	 * @return int
	 */
	public function authenticate()
	{
		$this->_id = null;

		if (empty($this->username))
			return $this->errorCode==self::ERROR_UNKNOWN_IDENTITY;

		if (empty($this->password))
			return $this->errorCode==self::ERROR_PASSWORD_INVALID;

		$loginName=strtolower(trim($this->username));
		$pw = Account::hashPassword($this->password);

		$criteria = new EMongoCriteria;
		$criteria->account->loginname = $loginName;

		$userModel=User::model()->active()->validFromTo()->find($criteria);

		if($userModel===null)
			$this->errorCode=self::ERROR_UNKNOWN_IDENTITY;

		elseif(!$userModel->account->validatePassword($this->password))
			$this->errorCode=self::ERROR_PASSWORD_INVALID;
		else
		{
			$this->_id=$userModel->_id;
			$this->username=$loginName;

			//assign the roles to yii user session
			//$userRoles = array ($role => $description, ...)
			$userRoles = $userModel->getRoles();

			//add the role 'authenticated'
			$userRoles = array_merge($userRoles,Yii::app()->getRoleTypeAuthenticated());

			$this->setState('roles', $userRoles);
			//the docroute of the user is the user type (BELONGS_TO_RELATION)
			$this->setState('docroute', $userModel->docroute);
			$this->setState('isRoot', (boolean)$userModel->account->root);

			$userModel->updateLastLogin();

			$this->errorCode=self::ERROR_NONE;
		}
		return $this->errorCode==self::ERROR_NONE;
	}


	/**
	 * Return the mongodbId
	 *
	 */
	public function getId()
	{
		return $this->_id;
	}
}
