<?php

/**
 * MongoCmsFileWidget.php
 *
 * A widget for rendering the attachments of a page
 * @see MongoCmsUtil.listAttachments
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class MongoCmsFileWidget extends CWidget {
    public $form; //boolean: true if in updateform
    public $model;
    public $htmlOptions;
    public $viewName = '_attachments';
	public $method = 'renderEditForm';

    /**
     * Renders the attachments in _form.php
     * _id from the related MongoCmsFile in GridFS as hidden field
     * checkbox to enable remove on save
     *
     * @see Page->beforeSave()
     */
    protected function renderEditForm()
    {
        $modelClass = $this->model->getModelClass();

        echo CHtml::label(MongoCmsModule::t('Attachments'), null);
        echo MongoCmsModule::t('Check to remove on save');

        $idx = 0;
        if (is_array($this->model->attachments))
            foreach ($this->model->attachments as $attachment) {
            // Important: generate hidden fields for _id to ensure the attachments can be rebuild on update!
            echo CHtml::activeHiddenField($this->model, "attachments[$idx][_id]");
            // need too, because of form reload on error
            echo CHtml::activeHiddenField($this->model, "attachments[$idx][orgfilename]");
            // add checkbox for removing the attachment on save
            echo '<div class="row">';

            $removeCheckbox = CHtml::activeCheckBox($this->model, "attachments[$idx][remove]");
			//download link for the uploaded file
			$downloadLink = MongoCmsFile::downloadLink($attachment['orgfilename'], $attachment['_id']);

			echo CHtml::label($downloadLink . ' ' . $removeCheckbox, false);

            //view thumnail image (or original) if attachment has mimetype image
			if ($imageurl = $this->model->getAttachmentImageUrl($attachment,'thumbnail'))
                echo CHtml::image($imageurl);

            echo '</div>';

            $idx++;
        }
    }

    /**
     * Renders the view _attachments.php
     *
     * @return
     */
    protected function renderView()
    {
        $this->getController()->renderPartial($this->viewName, array(
                'model' => $this->model,
                'htmlOptions' => $htmlOptions,
                ));
    }

    public function run()
    {
    	if (method_exists($this,$this->method))
    		$this->{$this->method}();
    	else
    		throw CException('Invalid method: ' .$this->method);

    }
}
