<?php

/**
 * MongoCmsEmbeddedForm.php
 *
 * This is an 'ActiveForm' without output of formbegin and formend
 * Need for embedding settings form into page form
 * @see Page.createSettingsForm()
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class MongoCmsEmbeddedForm extends CActiveForm
{

	/**
	 * Initializes the widget.
	 * This renders the form open tag.
	 */
	public function init()
	{
		if(!isset($this->htmlOptions['id']))
			$this->htmlOptions['id']=$this->id;
/*  No formbegin output
		if($this->stateful)
			echo CHtml::statefulForm($this->action, $this->method, $this->htmlOptions);
		else
			echo CHtml::beginForm($this->action, $this->method, $this->htmlOptions);
*/
	}

	/**
	 * Runs the widget.
	 * This registers the necessary javascript code and renders the form close tag.
	 */
	public function run()
	{
		if(is_array($this->focus))
			$this->focus="#".CHtml::activeId($this->focus[0],$this->focus[1]);

	//	echo CHtml::endForm(); No formend output
		if((!$this->enableAjaxValidation || empty($this->_attributes)))
		{
			if($this->focus!==null)
			{
				Yii::app()->clientScript->registerScript('CActiveForm#focus',"
				        if(!window.location.hash)
				                $('".$this->focus."').focus();
				");
			}
			return;
		}

		$options=$this->clientOptions;
		if(isset($this->clientOptions['validationUrl']) && is_array($this->clientOptions['validationUrl']))
			$options['validationUrl']=CHtml::normalizeUrl($this->clientOptions['validationUrl']);

		$options['attributes']=array_values($this->_attributes);

		if($this->_summary!==null)
			$options['summaryID']=$this->_summary;

		if($this->focus!==null)
			$options['focus']=$this->focus;

		$options=CJavaScript::encode($options);
		Yii::app()->clientScript->registerCoreScript('yiiactiveform');
		$id=$this->id;
		Yii::app()->clientScript->registerScript(__CLASS__.'#'.$id,"\$('#$id').yiiactiveform($options);");
	}

}
?>