<?php

/**
 * MongoCmsDocument.php
 *
 * The base class for page
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class MongoCmsDocument extends EMongoSoftDocument {

	/**
	 * The mongo collection where this document is stored
	 * @return string
	 */
	public function getCollectionName()
	{
		return 'mongocms_content';
	}

	/**
	 * Problems with different versions of  YiiMongoDbSuite
	 *
	 * This method should return a EMongoDocumentDataProvider not a EMongoDocument (as in older versions)
	 *
	 * @see views/admin/admin.php
	 *
	 * @param mixed $caseSensitive
	 * @return EMongoDocumentDataProvider
	 */


	public function search($caseSensitive = false)
	{
		$result = parent::search($caseSensitive); //older versions returns the model
	    if(!($result instanceof EMongoDocumentDataProvider))
            $result = new EMongoDocumentDataProvider($result);
		return $result;
	}

}
