<?php

/**
 *
 * MongoCmsDataProvider.php
 *
 * Create DataProvider which returns content data
 * where access to docroute / content / contenttype is allowed
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class MongoCmsDataProvider extends EMongoDocumentDataProvider
{
	public $modelclass = 'Page'; //need for collectionName
	public $modelclassOnly = false;
	public $allowedOperations = 'view';
	public $publishedOnly = false;
	public $rootDocRoute = null;  //find all docroute starting with rootDocRoute
	public $docRoute = null;
	public $docRouteId = null;
	public $criteria = null;
	public $language = null;
	public $tags = null;
	public $select = null;
	public $limit = null;
	public $offset = null;
	public $sort = array(
          'weight' => EMongoCriteria::SORT_ASC,
          'modified' => EMongoCriteria::SORT_DESC,
        );


	/**
	 * Constructor.
	 */
	public function __construct($config = array())
	{
		if (!empty($config))
			foreach($config as $key=>$value)
				$this->$key=$value;

		$criteria = $this->getCriteriaArray();
		parent::__construct($this->modelclass, array('criteria' => $criteria));
	}


	/**
	 * Add EEmbeddedArraysBehavior
	 * @link http://canni.github.com/YiiMongoDbSuite/xhtml/basic.arrays.embedded-documents.html
	 *
	 * @return
	 */
	public function behaviors()
	{
		return array(
		    'contentBehavior' => array(
		        'class'=>'MongoCmsContentBehavior',
		    ),
		);
	}

	/**
	 * Return the criteria
	 *
	 * @return EMongoCriteria
	 */
	public function getCriteriaArray()
	{
		$collectionName = Page::model($this->modelclass)->getCollectionName();
		$returnOnFirstFound = false;

		if (!isset($this->criteria))
			$this->criteria = array();

		if ($this->modelclassOnly)
			$this->criteria['modelclass'] = $this->modelclass;

		if (isset($this->docRouteId))
				$this->criteria['docrouteid'] = $this->docRouteId;

		if (isset($this->docRoute))
			$this->criteria['docroute'] = $this->docRoute;

		//use memory cached DocRoute model
		//find all _id where access is allowed
		$allowedItems = Yii::app()->mongocmsDocRoute()->findAllowedDocumentIds(
		    $this->rootDocRoute,
			$this->criteria,
		    $this->publishedOnly,
		    false, //$returnOnFirstFound
		    $collectionName,
		    $this->allowedOperations,
		    $this->limit);

		$allowedIds = array();
		foreach ($allowedItems as $item)
			$allowedIds[] = new MongoID($item['_id']);

		$criteria = array(
		    'conditions' => array(
		        '_id' => array('in' => $allowedIds),
		        ),
		    'sort' => $this->sort,
		    );

		if (isset($this->language))
			$criteria['conditions']['language'] = $this->language;

		if (isset($this->tags))
			$criteria['conditions']['tags'] = array('in' => $this->tags);

		if (isset($this->limit))
			$criteria['limit'] = $this->limit;

		if (isset($this->offset))
			$criteria['offset'] = $this->offset;

		if (isset($this->select))
			$criteria['select'] = $this->select;

		return $criteria;
	}


}
