<?php

/**
 * MongoCmsContentPortlet.php
 *
 * A portlet that uses data from MongoCmsContentProvider
 *
 * @see views/layouts/frontpage.php
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
Yii::import('zii.widgets.CPortlet');

class MongoCmsContentPortlet extends CPortlet
{

    public $emptyMessage = 'No items found';
	public $method;
	public $methodParams = array();
	public $viewData = array();

	/**
     * Returns the view to render
     * This is the id of the widget with prefix '_'
     *
     * @return string
     */
    protected function getView()
    {
        return $this->id;
    }

    /**
     * Renders the content
     */
    public function renderContent()
    {
    	$provider = new MongoCmsContentProvider();
		if ((!empty($this->method)) &&
    		method_exists($provider, $this->method))
    	  $dataProvider = call_user_func_array(array($provider, $this->method),$this->methodParams);

    	if (!empty($dataProvider) && ($dataProvider instanceof CDataProvider) && $dataProvider->itemCount)
    	{

    		$this->controller->renderPartial($this->getView(),
                                        array(
    					                  'dataProvider' => $dataProvider,
    					                  'viewData' => $this->viewData,
    					                 ));
    	}

    	else
    		echo MongoCmsModule::t($emptyMessage);
    }
}
