<?php

/**
 * MongoCmsConfiguration.php
 *
 * Load/apply configurations from mongocms directories config
 * The path depends on the configured theme:
 * config/THEMEID/...
 *
 * The relative path in the config directory should be the same as
 * the themename.
 * The theme is a public property in MongoCmsModule.php
 *
 * Searchpath:
 * If this is a submodule
 * 1. config/theme of the submodule
 * 1. config/theme of mongocms (if not found in submodule)
 *
 * PHP version 5.2+
 *
 * @author Joe Blocher <yii@myticket.at>
 * @copyright 2011 myticket it-solutions gmbh
 * @license New BSD License
 * @category User Interface
 * @package modules.mongocms.MongoCmsModule
 * @version 0.1
 * @since 0.1
 */
class MongoCmsConfiguration extends CConfiguration
{


	/**
	 * MongoCmsConfiguration::loadModuleConfig()
	 *
	 * @param mixed $module
	 * @param string $configFile
	 * @param boolean $searchMainModule
	 * @param boolean $mergeAll
	 * @param boolean $doInclude
	 * @param array $params
	 * @return boolean
	 */
	public function loadModuleConfig($module,$configFile,$searchMainModule = true,
		                             $mergeAll=false,$doInclude=false,$params=array())
	{
		if (is_object($module))
			$moduleId = $module->id;
		else
		if (is_string($module))
			{
			  if (!$moduleInstance = Yii::app()->getModule($module))
				return false;
			  $moduleId = $moduleInstance->id;
			}
		else
			return false;

		if (!empty($params))
			extract($params);

        $theme = Yii::app()->theme->name;
		$loaded = false;
		// search in config/THEME/$configFile.php of the module
		$cfgFile = Yii::getPathOfAlias($moduleId . ".config.$theme." . $configFile) . '.php';
		if (is_file($cfgFile))
		{
			if ($doInclude)
				include($cfgFile);
			else
			   $this->loadFromFile($cfgFile);
			$loaded = true;
			if (!$mergeAll) return $loaded;
		}

			// search in custom or main config of mongocms
		if ($searchMainModule && $module->isSubModule())
		{
			die('x');
			$cfgFile = Yii::getPathOfAlias("mongocms.config.$theme." . $configFile) . '.php';
			if (is_file($cfgFile)) {
				if ($doInclude)
					include($cfgFile);
				else
					$this->loadFromFile($cfgFile);
				$loaded = true;
				if (!$mergeAll) return $loaded;
			}
		}

		return $loaded;
	}


	/**
	 * Applies a ModulConfigFile to an object
	 *
	 * @param string $configFile
	 * @return CConfiguration
	 */
	public function applyModuleConfigTo(object $object, $moduleId, $configFile,$mergeAll=false)
	{
		if ($this->loadModuleConfig($moduleId,$configFile,$mergeAll))
		{
			$this->applyTo($object);
			return true;
		}

		return false;
	}


	/**
	 * Includes a script from config/THEME/script
	 * Searchpath:
	 * - current module/submodule
	 * - if is submodule an not exists, search in mongocms module
	 *
	 *
	 * @param mixed $script
	 * @param mixed $params extracted values within the script
	 * @return boolean true if included
	 */
	public function includeScript($script,$params=array())
	{
		return $this->loadModuleConfig(Yii::app()->controller->module,
							    		$script,
							    		true, //$searchMainModule
							    		false, //$mergeAll
							    		true, //$doInclude
							    		$params
							    		);
	}
}
