<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
	'name'=>'My Web Application',


	'defaultController' => 'content',

	'controllerMap' => array(
		'admin' => 'application.modules.mongocms.controllers.AdminController',
		'files' => 'application.modules.mongocms.controllers.FileController',
		'content' => 'application.modules.mongocms.controllers.ContentController',
		'user' => 'application.modules.mongocms.controllers.UserController',
	),

	'behaviors' => array(
	   'mongocms' => 'mongocms.components.MongoCmsBehavior',
	),

	// preloading 'log' component
	'preload'=>array('log'),

	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.components.*',
		'ext.YiiMongoDbSuite.*',
	),

	'modules'=>array(

		'mongocms' => array(
            // 'mongoConnectionId' => 'mongodb'  //(default)
            'modules' => array(
                'slideshow',
                ),
            ),

		// uncomment the following to enable the Gii tool
		/*
		'gii'=>array(
			'class'=>'system.gii.GiiModule',
			'password'=>'Enter Your Password Here',
		 	// If removed, Gii defaults to localhost only. Edit carefully to taste.
			'ipFilters'=>array('127.0.0.1','::1'),
		),
		*/
	),

	// application components
	'components'=>array(

		'mongodb' => array(
            'class' => 'EMongoDB',
            'connectionString' => 'mongodb://localhost',
            'dbName' => 'mongocms',
            'fsyncFlag' => true,
            'safeFlag' => false,
            'useCursor' => false
        ),

		'user' => array(
            'allowAutoLogin' => true,
            'loginUrl' => array('/user/login'),
			              //or /mongocms/user/login if the controllerMap is not used
        ),

		'urlManager' => array(
			'urlFormat' => 'path',
			'rules' => array(
			   // '<controller:\w+>/<id:\d+>' => '<controller>/view',
			   // '<controller:\w+>/<action:\w+>/<id:\d+>' => '<controller>/<action>',
			   //  '<controller:\w+>/<action:\w+>' => '<controller>/<action>',
			 ),
	    ),

		'db'=>array(
			'connectionString' => 'sqlite:'.dirname(__FILE__).'/../data/testdrive.db',
		),
		// uncomment the following to use a MySQL database
		/*
		'db'=>array(
			'connectionString' => 'mysql:host=localhost;dbname=testdrive',
			'emulatePrepare' => true,
			'username' => 'root',
			'password' => '',
			'charset' => 'utf8',
		),
		*/
		'errorHandler'=>array(
			// use 'site/error' action to display errors
            'errorAction'=>'site/error',
        ),
		'log'=>array(
			'class'=>'CLogRouter',
			'routes'=>array(
				array(
					'class'=>'CFileLogRoute',
					'levels'=>'error, warning',
				),
				// uncomment the following to show log messages on web pages
				/*
				array(
					'class'=>'CWebLogRoute',
				),
				*/
			),
		),
	),

	// application-level parameters that can be accessed
	// using Yii::app()->params['paramName']
	'params'=>array(
		// this is used in contact page
		'adminEmail'=>'webmaster@example.com',
	),
);