<?php
/* SVN FILE: $Id: HamlBaseFilter.php 49 2010-04-04 10:51:24Z chris.l.yates $ */
/**
 * Base Filter for {@link http://haml-lang.com/ Haml} class file.
 * @author			Chris Yates <chris.l.yates@gmail.com>
 * @copyright		Copyright (c) 2010 PBM Web Development
 * @license			http://phamlp.googlecode.com/files/license.txt
 * @package			PHamlP
 * @subpackage	Haml.filters
 */

/**
 * Base Filter for {@link http://haml-lang.com/ Haml} class.
 * This class must be extended and the run() method overridden.
 * @package			PHamlP
 * @subpackage	Haml.filters
 */
abstract class HamlBaseFilter {
	/**
	 * Initialise the filter.
	 */
	public function init() {}

	/**
	 * Run the filter.
	 * This method must be overridden in child classes.
	 * @param string text to filter
	 */
	abstract public function run($text);
}