<?php

/**
 * @Method          : FB Search 
 * @Params          :
 * @author          : Ankit Modi
 * @created         : JULY 31 2014
 * @Modified by     :
 * @modified        :
 * @Comment         : Facebook Search functionality 
 */
class Search extends CApplicationComponent {

    public $cs;

    public function __construct()
    {
        $this->cs = Yii::app()->getClientScript();
        $this->loadCSS();
    }

    /* load a view */
    public function CallView($params) {
        $view = $this->layout($params);
        echo $this->js();
    }

    /* load a css file */
    public function loadCSS()
    {
        return $this->cs->registerCssFile(Yii::app()->baseUrl.'/css/search.css');
    }
   
    
    /*load a layout */
    public function layout($params){
        $string = $this->getProfileInfo($params);


        echo <<<FORM
              <div class="holder">
                    <div class="search-holder">
                      <div class="title fl">Friends</div>
                          <div class="textbox fl">
                             <input type="text" name="search" onkeypress="showMessage();" class="search" value="" placeholder="Search Your Friends" autocomplete="off"> 
                         </div>
                    </div>
                    <div class="friends">$string</div>
                     
                </div> 

FORM;
    }

    /*load a dynamic profile div*/
    public function getProfileInfo($params){
        $string = '';
        foreach( $params as $key => $value){
            $string .= '<div class="friend_holder fl" id="'.$key.'">
                            <div class="photo fl"><img height ="80" width="80" src="'.$this->getImageDisplay($value).'"></div>
                            <div class="name fl"><a href="#">'.$key.'</a></div>
                        </div>';
        }
        return $string;
    }

    /*load dynamic profile image*/
    public function getImageDisplay($value) {
        if (file_exists(YiiBase::getPathOfAlias('webroot') .$value)) {
            $image = Yii::app()->baseUrl .$value;
        }else{
            $image = Yii::app()->baseUrl.'/images/no_image.png';
        }
        return $image;
    }

    /*load js keyup function */
    public function js(){
        $strJs = '<script>
                    function showMessage() {
                        $(".search").keyup(function(){
                            var str = $(".search").val();
                            $(".friends .friend_holder").each(function(index){
                                if($(this).attr("id")){
                                    if(!$(this).attr("id").match(new RegExp(str, "i"))){
                                        $(this).fadeOut("fast");
                                    }else{
                                        $(this).fadeIn("slow");
                                    }
                                }
                            });    
                        });
                    };
                </script>';
        return $strJs;
    }

}
?>