<?php
	class ERaptor extends CWidget
	{
		public $start;
		public $end;

		private $_asset_url;

		public function run()
		{
			// the easiest scenario, if we don't have
			// the start and end time set ... we just call
			// the lizard
			if( ! $this->start && ! $this->end )
			{
				$this->_callRaptor();	
				return;
			}

			$now = new DateTime();

			// the second easiest scenario if the start time is set
			// but not the end time, because we just check if the 
			// current time is larger than the start time
			if( $this->start && ! $this->end  )
			{
				$start = new DateTime( date( 'Y-m-d H:i:s', strtotime( $this->start ) ) );
				if( $now > $start )
				{
					$this->_callRaptor();
				}

				return;
			}

			// let's see if they set both the start and the end
			// time, how we're gonna handle that ...
			if( $this->start && $this->end )
			{
				// first we're gonna check if either of these elements have 
				// an X character in them ...
				if( strstr( $this->start,'X' ) || strstr( $this->end, 'X' ) )
				{
					// this is when the fun begins, we're gonna take the 
					// timers apart, replace the Xs with the current time piece
					// ie: if the year is XXXX, in the year of 2011 we return 2011
					// if the month is XX and the current month is April, we return 04
					// and so on ...
					$start 	= new DateTime( $this->_handleX( $this->start ) );
					$end	= new DateTime( $this->_handleX( $this->end ) );

					if( $start < $now && $now < $end )
					{
						$this->_callRaptor();
					}

				}
				else
				{
					// it's easy, we just make sure that the time is 
					// between start and end ...
					$start 	= new DateTime( date( 'Y-m-d H:i:s', strtotime( $this->start ) ) );
					$end 	= new DateTime( date( 'Y-m-d H:i:s', strtotime( $this->end ) ) );

					if( $start < $now && $now < $end )
					{
						$this->_callRaptor();
					}
				}
			}
		}

		private function _callRaptor()
		{
			$cs = Yii::app()->getClientScript();
			$cs->registerCoreScript('jquery');
			$folder = dirname(__FILE__).DIRECTORY_SEPARATOR.'assets';
			$pub = Yii::app()->getAssetManager()->publish( $folder,false,-1,YII_DEBUG );
			$this->_asset_url = $pub;
			$cs->registerScriptFile($pub);

		    $cs->registerScriptFile( $this->_asset_url . '/jquery.raptorize.1.0.js' );
			$cs->registerScript( 'raptorassets', 'var raptorassets="' . $this->_asset_url . '";', CClientScript::POS_HEAD );

			echo '<a href="#" id="myraptor" class="myraptor"></a>';

			$cs->registerScript( 
				'addraptor',
				"$(window).load(function() 
					{
						jQuery('.myraptor').raptorize();
					});
				",
				CClientScript::POS_END
			);
		}

		private function _handleX( $datewithx )
		{
			$now = time();

			// first let's assume we got something similar to this ...
			// XXXX-XX-XX XX:XX:XX
			// so let's split this in the middle ...
			// we have to take the date apart, searching for Xs
			$date_time_arr = explode( ' ', $datewithx );
			$date_with_x = $date_time_arr[0];
			$time_with_x = $date_time_arr[1];

			$date_in_pieces = explode( '-', $date_with_x );
			$year 	= stristr( $date_in_pieces[0], 'X' ) ? date( 'Y', $now ) : $date_in_pieces[0];
			$month	= stristr( $date_in_pieces[1], 'X' ) ? date( 'm', $now ) : $date_in_pieces[1];
			$day	= stristr( $date_in_pieces[2], 'X' ) ? date( 'd', $now ) : $date_in_pieces[2];

			$time_in_pieces = explode( ':', $time_with_x );
			$hour	= stristr( $time_in_pieces[0], 'X' ) ? date( 'H', $now ) : $time_in_pieces[0];
			$min	= stristr( $time_in_pieces[1], 'X' ) ? date( 'i', $now ) : $time_in_pieces[1];
			
			return "$year-$month-$day $hour:$min";
		}
	}
