Widget que provee dropDownList dependientes
===========================================

por: Ramiro Anacona Meneses	<anacona16@gmail.com>

Probado en: Yii  1.1.13

EDropDownsDependents es un widget para [Yii Framework](http://www.yiiframework.com "Yii Framework") desarrollado para facilitar el uso de Combos dependientes en formularios.

De una manera mas directa tenemos el siguiente ejemplo: Una relacion Maestro-Detalles entre Paises y Departamentos/Estados, y un Maestro-Detalle entre Departamentos/Estados y Municipios y asi segun se necesite.

En esta imagen se puede ver el model ER entre las tablas

![Master Detail Capture](https://bitbucket.org/anacona16/edropdownsdependents/downloads/master-detail.png "Master Detail Capture")

Como se puede ver la tabla tb_cpoblados (Centro poblados, lo que seria pueblos mas pequeños dentro de municipios) al crear un nuevo registro de donde se requiera el codigo de un Municipio tendriamos que indicar el Departamento/Estado, pero listar todos los Departamentos/Estados en un solo DropDownList no seria lo mejor, por eso se utilizan Combos dependientes, siguiendo el ejemplo, para seleccionar un municipio anteriormente debi seleccionar un Departamento/Estado y para hacer esto ultimo debi antes seleccionar un Pais (El ejemplo lo hice con toda esta jerarquia para mostrar que EDropDownsDependents puede usarse en un mismo formulario varias veces)

Al usar EDropDownsDependents para el ejemplo antes descrito, al final se mirara asi:

![EDropDownsDependents Capture](https://bitbucket.org/anacona16/edropdownsdependents/downloads/screenshotDropDown.png "EDropDownsDependents Capture")

INSTALAR
--------

## 1) Clonar el repositorio GIT

    cd /home/myapp/protected/extensions
    git clone https://anacona16@bitbucket.org/anacona16/edropdownsdependents.git

    Si no usa GIT copie la carpeta completa edropdownsdependents en su carpeta de extensions

### DESCARGA DIRECTA
Por favor descargue el zip, y descomprima en /protected/extensions/edropdownsdependents

## 2) Configure '/protected/config/main.php'

    'import'=>array(
      'application.models.*',
      'application.components.*',
      'ext.edropdownsdependents.*',   // <---
    ),

## 3) Configure la Accion

Conecte el widget con la aplicacion usando un Action en SiteController (o uno diferente si lo prefiere)

Por defecto, se usa:

myapp/protected/controllers/SiteController.php

IMPORTANTE:
  Esta configuracion es requerida solamente una vez para todo el proyecto


~~~
[php]
  public function actions()
  {
    return array(
      'captcha'=>array(
        'class'=>'CCaptchaAction',
        'backColor'=>0xFFFFFF,
      ),
      'page'=>array(
        'class'=>'CViewAction',
      ),
      'dropdowns'=>array(                       // <---
        'class'=>'EDropDownsDependentsAction',  // <---
      ),                                        // <---
    );
  }

~~~

## 4) Insertar y configurar el Widget

~~~
[php]
<?php
  $this->widget('ext.EDropDownsDependents.EDropDownsDependents', array(
    'model' => $model,
    'attribute' => 'codipais',
    'dataModel' => array(170 => 'Colombia'), //Modelo para obtener las opciones para el dropDownList puede ser String nombre del Modelo o array(key => value) Si es un segundo dropDown se pone un array() !Vacio
    'title' => 'descpais', //Nombre del campo de la tabla que se usara para mostrar en las opciones del dropDownList
    'targetModel' => 'Departamentos', //Nombre del modelo para consultar las opciones para el segundo dropDownList
    'targetField' => 'codipais', //Nombre del campo que guarda la relacion con la tabla superior
    'targetTitle' => 'nombdepa', //Nombre del campo que se usara para mostrar en las opciones del segundo dropDownList
    'dropDownListTarget' => 'codidepa', //Nombre de la propiedad en el modelo actual ej: $form->dropDownList($model, 'codimuni', array()); "codimuni"
    'htmlOptions' => array(
      'empty' => 'Seleccione Pais'
   ),
));
?>
~~~

## 5) Otras Opciones

~~~
[php]
'htmlOptions' => array(), // ver http://www.yiiframework.com/doc/api/1.1/CHtml#dropDownList-detail
'showImageCharging' => true, //Muestra gif Cargando
'defaultActionName' => '/site/dropdowns', //Si se cambia el Action se debe especificar en el controller
~~~
