<?php

class EDropDownsDependents extends CInputWidget implements EYuiActionRunnable {

  public $defaultAction = '/site/dropdowns'; //Se configura el acion en siteController.php asi: 'dropdowns' => array('class' => 'ext.EDropDownsDependents.EDropDownsDependentsAction')
  public $dataModel;                //Modelo de donde se sacaran las opciones para el dropDownList puede ser String nombre del Modelo o array(key => value) Si es un segundo dropDown dependiente pon un array()
  public $title = 'title';          //Nombre del campo de la tabla que se usara para mostrar en las opciones del dropDownList
  public $targetModel;              //Nombre del modelo para consultar las opciones para el segundo dropDownList
  public $targetField;              //Nombre del campo que guarda la relacion con la tabla superior
  public $targetTitle = 'title';    //Nombre del campo que se usara para mostrar en las opciones del segundo dropDownList
  public $dropDownListTarget;       //Nombre de la propiedad en el modelo actual ej: $form->dropDownList($model, 'codimuni', array()); "codimuni"
  public $showImageCharging = true; //Booleano muestra o no una imagen de cargando junto al lado derecho del dropDownList
  public $htmlOptions = array();    //htmlOptiones para el dropDownList ver http://www.yiiframework.com/doc/api/1.1/CHtml#dropDownList-detail
  private $_assetsFolder;
  private $_dataArrayOptions;

  public function init() {
    parent::init();

    $this->registerCoreScripts();
  }

  public function run() {

    if (is_array($this->dataModel)) {
      $this->_dataArrayOptions = $this->dataModel;
    }
    else {
      $dataModel = new $this->dataModel;
      $this->_dataArrayOptions = CHtml::listData($dataModel->model()->findAll(), $dataModel->model()->tableSchema->primaryKey, $this->title);
    }

    print CHtml::activeDropDownList($this->model, $this->attribute, $this->_dataArrayOptions, $this->htmlOptions);

    // preparamos algunas opciones para pasarselas al
    // objeto javascript llamado DropDowns que crearemos
    // mas abajo.
    $options = CJavaScript::encode(array(
           'firstField' => CHtml::activeId($this->model, $this->attribute),
           'action' => Yii::app()->createUrl($this->defaultAction), // importante
           'targetModel' => $this->targetModel,
           'targetField' => $this->targetField,
           'targetTitle' => $this->targetTitle,
           'dropDownListTarget' => CHtml::activeId($this->model, $this->dropDownListTarget),
           'showImageCharging' => $this->showImageCharging,
           'imageCharging' => CHtml::image($this->_assetsFolder . '/loading.gif', 'Cargando', array('id' => 'image-charging-edropdownlist')),
    ));

    // insertamos el objeto Javascript DropDowns, el cual reside
    // en un archivo JS externo (en los assets).
    // le pasamos las opciones a su constructor con el objeto de 
    // comunicar las dos piezas.
    Yii::app()->getClientScript()->registerScript("dropdowns_corescript_" . $this->attribute, "new DropDowns({$options})");
  }

  public function registerCoreScripts() {

    $localAssetsDir = dirname(__FILE__) . '/assets';
    $this->_assetsFolder = Yii::app()->getAssetManager()->publish($localAssetsDir);

    $cs = Yii::app()->getClientScript();

    foreach (scandir($localAssetsDir) as $f) {
      $_f = strtolower($f);
      if (strstr($_f, ".js"))
        $cs->registerScriptFile($this->_assetsFolder . "/" . $_f);
      if (strstr($_f, ".css"))
        $cs->registerCssFile($this->_assetsFolder . "/" . $_f);
    }
  }

  public function runAction($action, $data) {

    if ($action == 'dropdowns') {

      //Creamos instancia del modelo del cual se optendran los datos para el segundo dropDownList
      $model = new $data['targetModel'];
      //Nombre del campo que guarda la relacion entre las dos tablas master-detail
      $attribute = $data['targetField'];
      //Capturamos el ID necesario para hacer la consutla.
      $id = $data['id'];
      //Nombre del campo que se usara para mostrar en el segundo dropDownList
      $titleRelation = $data['targetTitle'];

      //Creo un CHtml::listData es mas facil para luego recorrer retorna un array con clave valor
      $list = CHtml::listData($model->model()->findAllByAttributes(array($attribute => $id)), $model->tableSchema->primaryKey, $titleRelation);

      $options = NULL;
      
      //Creo opciones para el segundo dropDownList
      foreach ($list as $key => $value) {
        $options .= '<option value="' . $key . '">' . $value . '</option>';
      }

      //Imprimo resultado final, que sera tomado por la peticion ajax como resultado
      print $options;
    }
  }

}