<?php
 /*
  * TODO
 
 */

class EActsAsVersioned extends CActiveRecordBehavior
{
	public $parentIdColumnName = 'parent_id' ;
	public $versionColumnName = 'version' ;
	public $timestampColumn = 'created_time' ;
	
	public function afterValidate() 
	{
		$owner = $this->getOwner() ;
		if ( !$owner->getIsNewRecord() )  // current version required
			$owner->{$this->versionColumnName} = $owner->getCurrent()->{$this->versionColumnName} + 1 ;
		else
			$owner->{$this->parentIdColumnName} = $this->owner->primaryKey ; // New record: id = parent_id
		$owner->setIsNewRecord(TRUE) ;	 	 // Make it an INSERT
		$owner->primaryKey = NULL ;		 // New record
		return true ;
	}

	public function afterSave() {
		if ( $this->getOwner()->{$this->parentIdColumnName} == null) {
			$owner = $this->getOwner() ;
			$sql = sprintf( 'UPDATE %s SET %s = %d WHERE %s = %d', 
				$owner->tableName(),
				$this->parentIdColumnName,
				$owner->primaryKey,
				$owner->getTableSchema()->primaryKey, 
				$owner->primaryKey ) ;
			Yii::app()->db->createCommand( $sql )->execute() ;
			$owner->{$this->parentIdColumnName} = $this->owner->primaryKey ;
		}
	}
	
	public function getCurrent($parent_id = null) {
		$owner = $this->getOwner() ;
		if ( !isset($parent_id) )
			$parent_id = isset($owner->primaryKey) ? $owner->{$this->parentIdColumnName} : null ;

		// select all current versions. The sub-query garentees that the highest version number is first ordered 
		$sql = sprintf('SELECT * FROM (SELECT * FROM %s ORDER BY  %s DESC) r1 WHERE %s > 0', 
				$owner->tableName(), 
				$this->versionColumnName, 
				$this->parentIdColumnName) ;

		// if set, load current version for a specific parent_id
		if ( isset($parent_id) )
			$sql .= sprintf( ' AND %s = :parent_id', $this->parentIdColumnName ) ;

		$sql .= '  GROUP BY r1.' . $this->parentIdColumnName ; // only take the current version (record with highest version number)
		
		$command = Yii::app()->db->createCommand($sql) ;

		if ( isset($parent_id) )
			$command->bindValue(':parent_id', $parent_id, PDO::PARAM_INT);	
		
		$models = $command->queryAll() ;
		if ( isset($parent_id) ) {
			return sizeof($models) == 1 ? $owner->populateRecord($models[0]) : null ; 
		}
		else {
			if ( sizeof($models) > 0 )
				return $owner->populateRecords($models) ;
			else
				return array() ;
		}
	}
	
	public function getVersions( $criteria = array(), $params = null ) {
		$owner = $this->getOwner() ;	

		if ( isset($owner->primaryKey) ) {
		
			$sql = sprintf( 'SELECT * FROM %s WHERE %s = :parent_id', 
					$owner->tableName(),
					$this->parentIdColumnName) ;

			if ( isset($criteria['condition']) )
				$sql .= sprintf(' AND (%s)', $criteria['condition']) ;

			$sql .= sprintf( ' ORDER BY %s ASC', $this->versionColumnName ) ;
	
			$command = Yii::app()->db->createCommand($sql) ;
			$command->bindValue(':parent_id', $owner->{$this->parentIdColumnName}, PDO::PARAM_INT);
			if ( isset($params) ) {
	                	foreach( $params as $key => $value ) {
                        		$command->bindValue($key, $value);
                		}
			}

			$versionList = $command->queryAll() ;

			$output = array() ;
			if ( isset($criteria['toModels']) && $criteria['toModels'] == true ) 
				$output = $owner->populateRecords($versionList) ;
			else {
				foreach( $versionList as $key => $value)  {
					$output[] = $value[$this->versionColumnName] ;
				}
			}
			return $output ;
		}
		return null ; // not for static usage
	}
	
	public function getVersion($version) {
		$model =  $this->getVersions( array('condition'=> $this->versionColumnName . ' = ' .$version, 'toModels'=>true) ) ;
		if ( sizeof($model) == 1 )
			return $model[0] ;
		else
			return null ;
	}

	public function getNextVersion() {
		return $this->getVersion( $this->getOwner()->{$this->versionColumnName} + 1 ) ;
	}
	public function getPreviousVersion() {
		return $this->getVersion( $this->getOwner()->{$this->versionColumnName} - 1 ) ;
	}
	public function isCurrent() {
		return $this->getOwner()->getNextVersion() == null ;
	}
}
