<?php

/**
 * Ducis Counter
Extract duciscounter folder to your extensions folder and use following code to display count down timer

With Minimal Configurations

$this->widget('ext.duciscounter.DucisCounter', 
        array(
              'start_timestamp' => strtotime("2014-04-04 02:00:00 GMT"), 
              'end_timestamp' => strtotime("2014-05-04 02:00:00 GMT"), 
               'now' => strtotime("2014-04-02 02:00:00 GMT")
            )
        );
Full Configurations

$this->widget('ext.duciscounter.DucisCounter', 
        array(
              'header'=>'Header',
              'body'=>'body',
               'footer'=>'footer',
              'start_timestamp' => strtotime("2014-04-04 02:00:00 GMT"), 
              'end_timestamp' => strtotime("2014-05-04 02:00:00 GMT"), 
               'now' => strtotime("2014-04-02 02:00:00 GMT")
            )
        );
 *  * @author Rohit Singhal 
 * @ www.ducistech.com
 */

class DucisCounter extends CWidget{
        
        //other options as defined by the jquery widget
        public $options = array();
		public $header;
		public $body;
		public $footer;
        //Unix Time Stamps
        public $start_timestamp;
        public $end_timestamp;
        public $now;
        //css file used for the widget
        public $cssFile;
        //javascript file for the widget
        public $jsFile;
        
        public function init() {
            $path = Yii::app()->getAssetManager()->publish(
                    Yii::getPathOfAlias('ext.duciscounter.src', -1, false));
            
            $this->jsFile = $path . '/ducisclock.js';
            $this->cssFile = $path . '/ducisclock.css';
            $cs = Yii::app()->clientScript;
            //$cs = new CClientScript;
            $cs->registerScriptFile($this->jsFile);
            $cs->registerCssFile($this->cssFile);
			$script = 'DucisCountDown({
                    secondsColor : "#ffdc50",
                    secondsGlow  : "none",
                    
                    minutesColor : "#9cdb7d",
                    minutesGlow  : "none",
                    
                    hoursColor   : "#378cff",
                    hoursGlow    : "none",
                    
                    daysColor    : "#ff6565",
                    daysGlow     : "none",
                    
                    startDate   : "'.$this->start_timestamp.'",
                    endDate     : "'.$this->end_timestamp.'",
                    now         : "'.$this->now.'",
                    seconds     : "57"
                });'; 
			 
            $cs->registerScript('count-down-script', $script);
        }
        
        public function run() {
		if($this->now == ""){
			$this->now = time();
		}
		
		if($this->header == ""){
			$this->header = "<h1>This website is under construction!</h1>";
		}
		
		if($this->body == ""){
			$this->body = "<h4>We will be live in:</h4>";
		}
		
		if($this->footer == "") {
			$this->footer = "<p>Plugin Developed By <a href='http://ducistech.com'>Ducis Technologies</a></p>";
		}
            echo '
		<div class="duciscounter" style="background-color:#000;">	
		<div class="wrapper">
		<h1>'.$this->header.'<h1>
		<h4>'.$this->body.'</h4>
		<div class="clock"><!--//-->
		<div class="clock_days">
		<div class="bgLayer">
		<div class="topLayer">
		</div><canvas id="canvas_days" width="188" height="188"> 
		</canvas><div class="text"><p class="val">209</p>
		<p class="type_days">Days</p>
		</div>
		</div>
		</div>
		<div class="clock_hours">
		<div class="bgLayer">
		<div class="topLayer">
		</div>
		<canvas id="canvas_hours" width="188" height="188"> 
		</canvas>
		<div class="text">
		<p class="val">5</p>
		<p class="type_hours">Hours</p>
		</div>
		</div>
		</div>
		<div class="clock_minutes">
		<div class="bgLayer">
		<div class="topLayer">
		</div><canvas id="canvas_minutes" width="188" height="188"> 
		</canvas><div class="text">
		<p class="val">46</p>
		<p class="type_minutes">Minutes</p>
		</div>
		</div>
		</div>
		<div class="clock_seconds">
		<div class="bgLayer">
		<div class="topLayer">
		</div><canvas id="canvas_seconds" width="188" height="188"> 
		</canvas>
		<div class="text">
		<p class="val">42</p>
		<p class="type_seconds">Seconds</p>
		</div>
		</div>
		</div>
		</div>
		<div class="divider"><p>'
		.$this->footer.
		'</p></div>
		</div>
		</div>
		';
        }
    
}

?>
