<?php
/**
 * This is the template for generating the model class of a specified table.
 * - $this: the ModelCode object
 * - $tableName: the table name for this class (prefix is already removed if necessary)
 * - $modelClass: the model class name
 * - $columns: list of table columns (name=>CDbColumnSchema)
 * - $labels: list of attribute labels (name=>label)
 * - $rules: list of validation rules
 * - $relations: list of relations (name=>relation declaration)
 * - $representingColumn: the name of the representing column for the table (string) or
 *   the names of the representing columns (array)
 */
/** @var AweModelCode $this */
?>
<?php echo "<?php\n"; ?>

/**
 * This is the model base class for the table "<?php echo $tableName; ?>".
 * DO NOT MODIFY THIS FILE! It is automatically generated by AweCrud.
 * If any changes are necessary, you must set or override the required
 * property or method in class "<?php echo $modelClass; ?>".
 *
 * Columns in table "<?php echo $tableName; ?>" available as properties of the model,
<?php if(!empty($relations)): ?>
 * followed by relations of table "<?php echo $tableName; ?>" available as properties of the model.
<?php else: ?>
 * and there are no model relations.
<?php endif; ?>
 *
<?php foreach($columns as $column): ?>
 * @property <?php echo $column->type.' $'.$column->name."\n"; ?>
<?php endforeach; ?>
 *
<?php foreach(array_keys($relations) as $name): ?>
 * @property <?php
    $relationData = $this->getRelationData($modelClass, $name);
    $relationType = $relationData[0];
    $relationModel = $relationData[1];

    switch($relationType) {
        case AweActiveRecord::BELONGS_TO:
        case AweActiveRecord::HAS_ONE:
            echo $relationModel;
            break;
        case AweActiveRecord::HAS_MANY:
        case AweActiveRecord::MANY_MANY:
            echo $relationModel . '[]';
            break;
        default:
            echo 'mixed';
    }
    echo ' $' . $name . "\n";
    ?>
<?php endforeach; ?>
 */
abstract class <?php echo $this->baseModelClass; ?> extends <?php echo $this->baseClass; ?> {

    public static function model($className=__CLASS__) {
        return parent::model($className);
    }
<?php if($connectionId!='db'):?>

    /**
     * @return CDbConnection database connection
     */
    public function getDbConnection()
    {
        return Yii::app()-><?php echo $connectionId ?>;
    }
<?php endif?>

    public function tableName() {
        return '<?php echo $tableName; ?>';
    }

    public static function representingColumn() {
<?php if (is_array($representingColumn)): ?>
        return array(
<?php foreach($representingColumn as $representingColumn_item): ?>
            '<?php echo $representingColumn_item; ?>',
<?php endforeach; ?>
        );
<?php else: ?>
        return '<?php echo $representingColumn; ?>';
<?php endif; ?>
    }

    public function rules() {
        return array(
<?php foreach($rules as $rule): ?>
            <?php echo $rule.",\n"; ?>
<?php endforeach; ?>
            array('<?php echo implode(', ', array_keys($columns)); ?>', 'safe', 'on'=>'search'),
        );
    }

    public function relations() {
        return array(
<?php foreach($relations as $name => $relation): ?>
            <?php echo "'{$name}' => {$relation},\n"; ?>
<?php endforeach; ?>
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
<?php foreach($labels as $name => $label): ?>
<?php if($label === null): ?>
                <?php echo "'{$name}' => null,\n"; ?>
<?php else: ?>
                <?php echo "'{$name}' => {$label},\n"; ?>
<?php endif; ?>
<?php endforeach; ?>
        );
    }

    public function search() {
        $criteria = new CDbCriteria;

<?php foreach($columns as $name => $column): ?>
<?php if($column->type === 'string' and !$column->isForeignKey): ?>
        $criteria->compare('<?php echo $name ?>', $this-><?php echo $name ?>, true);
<?php else: ?>
        $criteria->compare('<?php echo $name ?>', $this-><?php echo $name ?>);
<?php endif;?>
<?php endforeach; ?>

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function behaviors() {
        return array_merge(array(
<?php if(!empty($this->relatedRecordBehavior)):?>
            '<?php echo $this->relatedRecordBehavior ?>' => array(
                'class' => '<?php echo $this->validRelatedRecordBehaviors[$this->relatedRecordBehavior] ?>',
            ),
<?php endif; ?>
<?php foreach ($columns as $name => $column): ?>
<?php if (in_array($column->name, $this->time_fields)): ?>
            'CTimestampBehavior' => array(
                'class' => 'zii.behaviors.CTimestampBehavior',
                'createAttribute' => <?php echo $this->getCreatetimeAttribute($columns) ?>,
                'updateAttribute' => <?php echo $this->getUpdatetimeAttribute($columns) ?>,
                'timestampExpression' => new CDbExpression('NOW()'),
            )
<?php break; // once a column is found, we are done ?>
<?php endif; ?>
<?php endforeach; ?>
        ), parent::behaviors());
    }
}